/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.segment;

import java.util.HashMap;
import java.util.Map;
import org.trimou.Mustache;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.config.EngineConfigurationKey;
import org.trimou.engine.context.DebugExecutionContext;
import org.trimou.engine.context.DefaultExecutionContext;
import org.trimou.engine.context.ExecutionContext;
import org.trimou.engine.segment.AbstractContainerSegment;
import org.trimou.engine.segment.SegmentType;
import org.trimou.engine.segment.Segments;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;

public class TemplateSegment
extends AbstractContainerSegment
implements Mustache {
    private final MustacheEngine engine;
    private boolean readOnly = false;

    public TemplateSegment(String text, MustacheEngine engine) {
        super(text, null);
        this.engine = engine;
    }

    @Override
    public void render(Appendable appendable, Map<String, Object> data) {
        if (!this.isReadOnly()) {
            throw new MustacheException(MustacheProblem.TEMPLATE_NOT_READY, this.getName());
        }
        super.execute(appendable, this.newExecutionContext(data));
    }

    @Override
    public String render(Map<String, Object> data) {
        StringBuilder builder = new StringBuilder();
        this.render(builder, data);
        return builder.toString();
    }

    @Override
    public SegmentType getType() {
        return SegmentType.TEMPLATE;
    }

    @Override
    public String getLiteralBlock() {
        return this.getContainingLiteralBlock();
    }

    @Override
    public String getName() {
        return this.getText();
    }

    @Override
    public void performPostProcessing() {
        if (this.engine.getConfiguration().getBooleanPropertyValue(EngineConfigurationKey.REMOVE_STANDALONE_LINES).booleanValue()) {
            Segments.removeStandaloneLines(this);
        }
        if (this.engine.getConfiguration().getBooleanPropertyValue(EngineConfigurationKey.REMOVE_UNNECESSARY_SEGMENTS).booleanValue()) {
            Segments.removeUnnecessarySegments(this);
        }
        super.performPostProcessing();
        this.readOnly = true;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    protected MustacheEngine getEngine() {
        return this.engine;
    }

    private ExecutionContext newExecutionContext(Map<String, Object> data) {
        DefaultExecutionContext ctx = null;
        ctx = this.engine.getConfiguration().getBooleanPropertyValue(EngineConfigurationKey.DEBUG_MODE_ENABLED) != false ? new DebugExecutionContext(this.engine.getConfiguration().getResolvers()) : new DefaultExecutionContext(this.engine.getConfiguration().getResolvers());
        HashMap<String, Object> contextData = new HashMap<String, Object>();
        if (this.engine.getConfiguration().getGlobalData() != null) {
            contextData.putAll(this.engine.getConfiguration().getGlobalData());
        }
        if (data != null) {
            contextData.putAll(data);
        }
        if (!contextData.isEmpty()) {
            ctx.push(contextData);
        }
        return ctx;
    }
}

