/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.segment;

import java.io.StringWriter;
import org.trimou.engine.config.EngineConfigurationKey;
import org.trimou.engine.context.ExecutionContext;
import org.trimou.engine.segment.AbstractSegment;
import org.trimou.engine.segment.SegmentType;
import org.trimou.engine.segment.TemplateSegment;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;
import org.trimou.lambda.Lambda;

public class ValueSegment
extends AbstractSegment {
    private final boolean unescape;

    public ValueSegment(String text, TemplateSegment template, boolean unescape) {
        super(text, template);
        this.unescape = unescape;
    }

    @Override
    public SegmentType getType() {
        return SegmentType.VALUE;
    }

    public boolean isUnescape() {
        return this.unescape;
    }

    @Override
    public void execute(Appendable appendable, ExecutionContext context) {
        Object value = context.getValue(this.getText());
        if (value != null) {
            if (value instanceof Lambda) {
                this.processLambda(appendable, context, value);
            } else {
                this.writeValue(appendable, value.toString());
            }
        } else if (this.getEngineConfiguration().getBooleanPropertyValue(EngineConfigurationKey.NO_VALUE_INDICATES_PROBLEM).booleanValue()) {
            throw new MustacheException(MustacheProblem.RENDER_NO_VALUE);
        }
    }

    @Override
    protected String getSegmentName() {
        return this.getText();
    }

    private void writeValue(Appendable appendable, String text) {
        this.append(appendable, this.unescape ? text : this.getEngineConfiguration().getTextSupport().escapeHtml(text));
    }

    private void processLambda(Appendable appendable, ExecutionContext context, Object value) {
        Lambda lambda = (Lambda)value;
        String returnValue = lambda.invoke(null);
        if (lambda.isReturnValueInterpolated()) {
            StringWriter interpolated = new StringWriter();
            TemplateSegment temp = (TemplateSegment)this.getEngine().compileMustache(lambda.getClass() + "_" + System.nanoTime(), returnValue);
            temp.execute(interpolated, context);
            this.writeValue(appendable, interpolated.toString());
        } else {
            this.writeValue(appendable, returnValue);
        }
    }
}

