/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.context;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.trimou.engine.config.Configuration;
import org.trimou.engine.config.EngineConfigurationKey;
import org.trimou.engine.context.ExecutionContext;
import org.trimou.engine.resolver.Resolver;
import org.trimou.engine.segment.ExtendSectionSegment;
import org.trimou.engine.segment.TemplateSegment;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;
import org.trimou.util.Checker;

abstract class AbstractExecutionContext
implements ExecutionContext {
    protected Configuration configuration;
    protected Deque<Object> contextObjectStack = new ArrayDeque<Object>(8);
    protected Deque<TemplateSegment> templateInvocationStack = new ArrayDeque<TemplateSegment>(8);
    protected Map<String, ExtendSectionSegment> definingSections = null;
    private int templateRecursiveInvocationLimit;

    protected AbstractExecutionContext(Configuration configuration) {
        this.configuration = configuration;
        this.templateRecursiveInvocationLimit = configuration.getIntegerPropertyValue(EngineConfigurationKey.TEMPLATE_RECURSIVE_INVOCATION_LIMIT);
    }

    @Override
    public void push(ExecutionContext.TargetStack stack, Object object) {
        Checker.checkArgumentNotNull((Object)stack);
        Checker.checkArgumentNotNull(object);
        switch (stack) {
            case CONTEXT: {
                this.contextObjectStack.addFirst(object);
                break;
            }
            case TEMPLATE_INVOCATION: {
                this.pushTemplateInvocation((TemplateSegment)object);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid stack type");
            }
        }
    }

    @Override
    public Object pop(ExecutionContext.TargetStack stack) {
        Checker.checkArgumentNotNull((Object)stack);
        switch (stack) {
            case CONTEXT: {
                return this.contextObjectStack.removeFirst();
            }
            case TEMPLATE_INVOCATION: {
                return this.templateInvocationStack.removeFirst();
            }
        }
        throw new IllegalStateException("Invalid stack type");
    }

    @Override
    public void addDefiningSection(String name, ExtendSectionSegment segment) {
        if (this.definingSections == null) {
            this.definingSections = new HashMap<String, ExtendSectionSegment>(8);
        }
        if (!this.definingSections.containsKey(name)) {
            this.definingSections.put(name, segment);
        }
    }

    @Override
    public ExtendSectionSegment getDefiningSection(String name) {
        if (this.definingSections == null || this.definingSections.isEmpty()) {
            return null;
        }
        return this.definingSections.get(name);
    }

    protected Object resolveLeadingContextObject(String name) {
        Object contextObject;
        Object leading = null;
        Iterator<Object> i$ = this.contextObjectStack.iterator();
        while (i$.hasNext() && (leading = this.resolve(contextObject = i$.next(), name)) == null) {
        }
        if (leading == null) {
            leading = this.resolve(null, name);
        }
        return leading;
    }

    protected Object resolve(Object contextObject, String name) {
        Resolver resolver;
        Object value = null;
        Iterator<Resolver> i$ = this.resolvers().iterator();
        while (i$.hasNext() && (value = (resolver = i$.next()).resolve(contextObject, name)) == null) {
        }
        return value;
    }

    protected boolean isCompoundKey(String key) {
        return !key.equals(".") && key.contains(".");
    }

    protected String[] splitKey(String key) {
        return StringUtils.split((String)key, (String)".");
    }

    protected List<Resolver> resolvers() {
        return this.configuration.getResolvers();
    }

    private void pushTemplateInvocation(TemplateSegment template) {
        Checker.checkArgumentNotNull(template);
        if (this.getTemplateInvocations(template) > this.templateRecursiveInvocationLimit) {
            throw new MustacheException(MustacheProblem.RENDER_TEMPLATE_INVOCATION_RECURSIVE_LIMIT_EXCEEDED, "Recursive invocation limit exceeded [limit: %s, stack: %s]", this.templateRecursiveInvocationLimit, this.templateInvocationStack);
        }
        this.templateInvocationStack.addFirst(template);
    }

    private int getTemplateInvocations(TemplateSegment template) {
        int invocations = 0;
        for (TemplateSegment segment : this.templateInvocationStack) {
            if (!segment.equals(template)) continue;
            ++invocations;
        }
        return invocations;
    }
}

