/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.context;

import java.util.HashMap;
import java.util.Map;
import org.trimou.annotations.Internal;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.config.EngineConfigurationKey;
import org.trimou.engine.context.DebugExecutionContext;
import org.trimou.engine.context.DefaultExecutionContext;
import org.trimou.engine.context.ExecutionContext;

@Internal
public class ExecutionContextBuilder {
    private final MustacheEngine engine;
    private Map<String, Object> data;

    public ExecutionContextBuilder(MustacheEngine engine) {
        this.engine = engine;
    }

    public ExecutionContextBuilder withData(Map<String, Object> data) {
        this.data = data;
        return this;
    }

    public ExecutionContext build() {
        DefaultExecutionContext context = null;
        context = this.engine.getConfiguration().getBooleanPropertyValue(EngineConfigurationKey.DEBUG_MODE_ENABLED) != false ? new DebugExecutionContext(this.engine.getConfiguration()) : new DefaultExecutionContext(this.engine.getConfiguration());
        HashMap<String, Object> contextData = new HashMap<String, Object>();
        if (this.engine.getConfiguration().getGlobalData() != null) {
            contextData.putAll(this.engine.getConfiguration().getGlobalData());
        }
        if (this.data != null) {
            contextData.putAll(this.data);
        }
        if (!contextData.isEmpty()) {
            context.push(ExecutionContext.TargetStack.CONTEXT, contextData);
        }
        return context;
    }
}

