/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.locator;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trimou.engine.locator.FilePathTemplateLocator;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;

public class ClassPathTemplateLocator
extends FilePathTemplateLocator {
    private static final Logger logger = LoggerFactory.getLogger(ClassPathTemplateLocator.class);
    private ClassLoader classLoader;

    public ClassPathTemplateLocator(int priority, String rootPath) {
        this(priority, rootPath, Thread.currentThread().getContextClassLoader());
    }

    public ClassPathTemplateLocator(int priority, String rootPath, String suffix) {
        this(priority, rootPath, suffix, Thread.currentThread().getContextClassLoader());
    }

    private ClassPathTemplateLocator(int priority, String rootPath, String suffix, ClassLoader classLoader) {
        super(priority, rootPath, suffix);
        this.classLoader = classLoader;
        this.checkRootDir();
    }

    private ClassPathTemplateLocator(int priority, String rootPath, ClassLoader classLoader) {
        super(priority, rootPath);
        this.classLoader = classLoader;
        this.checkRootDir();
    }

    @Override
    public Reader locateRealPath(String realPath) {
        InputStream in = this.classLoader.getResourceAsStream(this.getRootPath() + this.addSuffix(realPath));
        if (in == null) {
            return null;
        }
        logger.debug("Template located: {}", (Object)(this.getRootPath() + realPath));
        return new InputStreamReader(in);
    }

    @Override
    protected File getRootDir() {
        try {
            URL url = this.classLoader.getResource(this.getRootPath());
            if (url == null) {
                throw new MustacheException(MustacheProblem.TEMPLATE_LOCATOR_INVALID_CONFIGURATION, "Root path resource not found: %s", this.getRootPath());
            }
            return new File(URLDecoder.decode(url.getFile(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new MustacheException(MustacheProblem.TEMPLATE_LOCATOR_INVALID_CONFIGURATION, (Throwable)e);
        }
    }
}

