/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.resolver.i18n;

import java.util.ResourceBundle;
import org.trimou.engine.priority.Priorities;
import org.trimou.engine.resolver.ArrayIndexResolver;
import org.trimou.engine.resolver.i18n.LocaleAwareResolver;

public class ResourceBundleResolver
extends LocaleAwareResolver {
    private String baseName;
    private int priority;

    public ResourceBundleResolver(String baseName) {
        this.baseName = baseName;
        this.priority = Priorities.after(ArrayIndexResolver.ARRAY_RESOLVER_PRIORITY);
    }

    public ResourceBundleResolver(String baseName, int priority) {
        this.baseName = baseName;
        this.priority = priority;
    }

    @Override
    public Object resolve(Object contextObject, String name) {
        ResourceBundle bundle;
        if (contextObject == null && this.baseName.equals(name)) {
            return ResourceBundle.getBundle(this.baseName, this.localeSupport.getCurrentLocale());
        }
        if (contextObject != null && contextObject instanceof ResourceBundle && (bundle = (ResourceBundle)contextObject).containsKey(name)) {
            return bundle.getObject(name);
        }
        return null;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }
}

