/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.util;

import java.beans.Introspector;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trimou.annotations.Internal;
import org.trimou.util.Checker;

@Internal
public final class Reflections {
    private static final Logger logger = LoggerFactory.getLogger(Reflections.class);
    private static final String GET_PREFIX = "get";
    private static final String IS_PREFIX = "is";

    private Reflections() {
    }

    public static Map<String, Method> getAccesibleMethods(Class<?> clazz) {
        long start = System.currentTimeMillis();
        Checker.checkArgumentNotNull(clazz);
        Method[] clazzMethods = clazz.getMethods();
        HashMap<String, Method> readMethods = new HashMap<String, Method>(clazzMethods.length);
        for (Method method : clazzMethods) {
            if (!Reflections.isAccesibleMethod(method)) continue;
            String methodName = method.getName();
            if (methodName.startsWith(GET_PREFIX)) {
                readMethods.put(Reflections.decapitalize(methodName, GET_PREFIX), method);
                continue;
            }
            if (methodName.startsWith(IS_PREFIX)) {
                readMethods.put(Reflections.decapitalize(methodName, IS_PREFIX), method);
                continue;
            }
            readMethods.put(methodName, method);
        }
        logger.debug("Accesible methods [type: {}, found: {}, time: {} ms]", new Object[]{clazz.getName(), readMethods.size(), System.currentTimeMillis() - start});
        return readMethods;
    }

    public static Method getAccesibleMethod(Class<?> clazz, String name) {
        Checker.checkArgumentNotNull(clazz);
        Checker.checkArgumentNotNull(name);
        Method found = null;
        for (Method method : clazz.getMethods()) {
            String methodName;
            if (!Reflections.isAccesibleMethod(method) || !(methodName = method.getName()).equals(name) && !Reflections.matchesPrefix(name, methodName, GET_PREFIX) && !Reflections.matchesPrefix(name, methodName, IS_PREFIX)) continue;
            found = method;
            break;
        }
        logger.debug("{} accesible method {}found [type: {}]", new Object[]{name, found != null ? "" : "not ", clazz.getName()});
        return found;
    }

    public static Field getAccesibleField(Class<?> clazz, String name) {
        Checker.checkArgumentNotNull(clazz);
        Checker.checkArgumentNotNull(name);
        Field found = null;
        for (Field accesibleField : clazz.getFields()) {
            if (!accesibleField.getName().equals(name)) continue;
            found = accesibleField;
        }
        logger.debug("{} accesible field {}found [type: {}]", new Object[]{name, found != null ? "" : "not ", clazz.getName()});
        return found;
    }

    public static boolean isAccesibleMethod(Method method) {
        if (method == null) {
            return false;
        }
        if (!Modifier.isPublic(method.getModifiers()) || method.getParameterTypes().length != 0 || method.getReturnType().equals(Void.TYPE)) {
            return false;
        }
        return !Object.class.equals(method.getDeclaringClass());
    }

    private static boolean matchesPrefix(String name, String methodName, String prefix) {
        return methodName.startsWith(prefix) && Reflections.decapitalize(methodName, prefix).equals(name);
    }

    private static String decapitalize(String methodName, String prefix) {
        return Introspector.decapitalize(methodName.substring(prefix.length(), methodName.length()));
    }
}

