/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.config;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.engine.config.Configuration;
import org.trimou.engine.config.ConfigurationAware;
import org.trimou.engine.config.ConfigurationExtension;
import org.trimou.engine.config.ConfigurationKey;
import org.trimou.engine.config.EngineConfigurationKey;
import org.trimou.engine.listener.MustacheListener;
import org.trimou.engine.locale.LocaleSupport;
import org.trimou.engine.locale.LocaleSupportFactory;
import org.trimou.engine.locator.TemplateLocator;
import org.trimou.engine.priority.HighPriorityComparator;
import org.trimou.engine.resolver.Resolver;
import org.trimou.engine.text.TextSupport;
import org.trimou.engine.text.TextSupportFactory;
import org.trimou.util.Strings;

class DefaultConfiguration
implements Configuration {
    private static final String RESOURCE_FILE = "/trimou.properties";
    private List<TemplateLocator> templateLocators = null;
    private List<Resolver> resolvers = null;
    private Map<String, Object> globalData = null;
    private TextSupport textSupport;
    private LocaleSupport localeSupport;
    private Map<String, Object> properties;
    private List<MustacheListener> mustacheListeners;

    DefaultConfiguration(MustacheEngineBuilder builder) {
        if (!builder.isOmitServiceLoaderConfigurationExtensions()) {
            Iterator<ConfigurationExtension> iterator = ServiceLoader.load(ConfigurationExtension.class).iterator();
            while (iterator.hasNext()) {
                iterator.next().register(builder);
            }
        }
        this.identifyResolvers(builder);
        this.identifyTextSupport(builder);
        this.identifyLocaleSupport(builder);
        this.identifyTemplateLocators(builder);
        this.identifyMustacheListeners(builder);
        this.initializeGlobalData(builder);
        this.initializeProperties(builder);
        this.initializeConfigurationAwareComponents();
    }

    @Override
    public List<Resolver> getResolvers() {
        return this.resolvers;
    }

    @Override
    public Map<String, Object> getGlobalData() {
        return this.globalData;
    }

    @Override
    public List<TemplateLocator> getTemplateLocators() {
        return this.templateLocators;
    }

    @Override
    public TextSupport getTextSupport() {
        return this.textSupport;
    }

    @Override
    public LocaleSupport getLocaleSupport() {
        return this.localeSupport;
    }

    @Override
    public List<MustacheListener> getMustacheListeners() {
        return this.mustacheListeners;
    }

    @Override
    public Long getLongPropertyValue(ConfigurationKey configurationKey) {
        Long value = (Long)this.properties.get(configurationKey.get());
        if (value == null) {
            value = (Long)configurationKey.getDefaultValue();
        }
        return value;
    }

    @Override
    public Integer getIntegerPropertyValue(ConfigurationKey configurationKey) {
        Integer value = (Integer)this.properties.get(configurationKey.get());
        if (value == null) {
            value = (Integer)configurationKey.getDefaultValue();
        }
        return value;
    }

    @Override
    public String getStringPropertyValue(ConfigurationKey configurationKey) {
        Object value = this.properties.get(configurationKey.get());
        if (value == null) {
            value = configurationKey.getDefaultValue();
        }
        return value.toString();
    }

    @Override
    public Boolean getBooleanPropertyValue(ConfigurationKey configurationKey) {
        Boolean value = (Boolean)this.properties.get(configurationKey.get());
        if (value == null) {
            value = (Boolean)configurationKey.getDefaultValue();
        }
        return value;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("----------");
        builder.append(Strings.LINE_SEPARATOR);
        builder.append("[");
        builder.append(this.getClass().getName());
        builder.append("]");
        if (this.templateLocators != null) {
            builder.append(Strings.LINE_SEPARATOR);
            builder.append("----------");
            builder.append(Strings.LINE_SEPARATOR);
            builder.append("[Template locators]");
            for (TemplateLocator templateLocator : this.templateLocators) {
                builder.append(Strings.LINE_SEPARATOR);
                builder.append(templateLocator.toString());
            }
        }
        if (this.resolvers != null) {
            builder.append(Strings.LINE_SEPARATOR);
            builder.append("----------");
            builder.append(Strings.LINE_SEPARATOR);
            builder.append("[Resolvers]");
            for (Resolver resolver : this.resolvers) {
                builder.append(Strings.LINE_SEPARATOR);
                builder.append(resolver.toString());
            }
        }
        builder.append(Strings.LINE_SEPARATOR);
        builder.append("----------");
        builder.append(Strings.LINE_SEPARATOR);
        builder.append("[Properties]");
        for (Map.Entry entry : this.properties.entrySet()) {
            builder.append(Strings.LINE_SEPARATOR);
            builder.append((String)entry.getKey());
            builder.append("=");
            builder.append(entry.getValue());
        }
        return builder.toString();
    }

    private Object getPropertyValue(Object defaultValue, Object suppliedValue) {
        if (defaultValue instanceof String) {
            return suppliedValue.toString();
        }
        if (defaultValue instanceof Boolean) {
            return Boolean.valueOf(suppliedValue.toString());
        }
        if (defaultValue instanceof Long) {
            return Long.valueOf(suppliedValue.toString());
        }
        if (defaultValue instanceof Integer) {
            return Integer.valueOf(suppliedValue.toString());
        }
        throw new IllegalStateException("Unknown configuration value");
    }

    private void initializeConfigurationAwareComponents() {
        for (ConfigurationAware component : this.getConfigurationAwareComponents()) {
            component.init(this);
        }
    }

    private void identifyResolvers(MustacheEngineBuilder builder) {
        this.resolvers = new ArrayList<Resolver>();
        if (builder.getResolvers() != null) {
            this.resolvers.addAll(builder.getResolvers());
        }
        Collections.sort(this.resolvers, new HighPriorityComparator());
        this.resolvers = ImmutableList.copyOf(this.resolvers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeProperties(MustacheEngineBuilder builder) {
        Properties resourceProperties;
        Set<ConfigurationKey> keysToProcess;
        block7: {
            keysToProcess = this.getConfigurationKeysToProcess();
            this.properties = new HashMap<String, Object>(keysToProcess.size());
            resourceProperties = new Properties();
            try {
                InputStream in = this.getClass().getResourceAsStream(RESOURCE_FILE);
                if (in == null) break block7;
                try {
                    resourceProperties.load(in);
                }
                finally {
                    in.close();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        for (ConfigurationKey configKey : keysToProcess) {
            String key = configKey.get();
            Object value = builder.getProperties().get(key);
            if (value == null && (value = System.getProperty(key)) == null) {
                value = resourceProperties.getProperty(key);
            }
            this.properties.put(key, value != null ? this.getPropertyValue(configKey.getDefaultValue(), value) : configKey.getDefaultValue());
        }
    }

    private Set<ConfigurationKey> getConfigurationKeysToProcess() {
        HashSet<ConfigurationKey> keys = new HashSet<ConfigurationKey>();
        for (EngineConfigurationKey key : EngineConfigurationKey.values()) {
            keys.add(key);
        }
        for (ConfigurationAware component : this.getConfigurationAwareComponents()) {
            keys.addAll(component.getConfigurationKeys());
        }
        return keys;
    }

    private void identifyTextSupport(MustacheEngineBuilder builder) {
        this.textSupport = builder.getTextSupport() != null ? builder.getTextSupport() : new TextSupportFactory().createTextSupport();
    }

    private void identifyLocaleSupport(MustacheEngineBuilder builder) {
        this.localeSupport = builder.getLocaleSupport() != null ? builder.getLocaleSupport() : new LocaleSupportFactory().createLocateSupport();
    }

    private void identifyTemplateLocators(MustacheEngineBuilder builder) {
        if (builder.getTemplateLocators() != null) {
            ArrayList<TemplateLocator> locators = new ArrayList<TemplateLocator>(builder.getTemplateLocators());
            Collections.sort(locators, new HighPriorityComparator());
            this.templateLocators = ImmutableList.copyOf(locators);
        }
    }

    private void initializeGlobalData(MustacheEngineBuilder builder) {
        if (builder.getGlobalData() != null) {
            this.globalData = ImmutableMap.copyOf(builder.getGlobalData());
        }
    }

    private void identifyMustacheListeners(MustacheEngineBuilder builder) {
        if (builder.getMustacheListeners() != null) {
            this.mustacheListeners = ImmutableList.copyOf(builder.getMustacheListeners());
        }
    }

    private Set<ConfigurationAware> getConfigurationAwareComponents() {
        HashSet<ConfigurationAware> components = new HashSet<ConfigurationAware>();
        components.addAll(this.resolvers);
        if (this.templateLocators != null) {
            components.addAll(this.templateLocators);
        }
        if (this.mustacheListeners != null) {
            components.addAll(this.mustacheListeners);
        }
        components.add(this.localeSupport);
        components.add(this.textSupport);
        return components;
    }
}

