/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine;

import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import org.trimou.Mustache;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.engine.config.Configuration;
import org.trimou.engine.config.ConfigurationFactory;
import org.trimou.engine.config.EngineConfigurationKey;
import org.trimou.engine.listener.MustacheCompilationEvent;
import org.trimou.engine.listener.MustacheListener;
import org.trimou.engine.locator.TemplateLocator;
import org.trimou.engine.parser.Parser;
import org.trimou.engine.parser.ParserFactory;
import org.trimou.engine.parser.ParsingHandler;
import org.trimou.engine.parser.ParsingHandlerFactory;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;
import org.trimou.util.Checker;
import org.trimou.util.Strings;

class DefaultMustacheEngine
implements MustacheEngine {
    private LoadingCache<String, Optional<Mustache>> templateCache;
    private Configuration configuration;
    private Parser parser;

    DefaultMustacheEngine() {
    }

    DefaultMustacheEngine(MustacheEngineBuilder builder) {
        this.configuration = new ConfigurationFactory().createConfiguration(builder);
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder();
        if (this.configuration.getBooleanPropertyValue(EngineConfigurationKey.DEBUG_MODE).booleanValue()) {
            cacheBuilder.maximumSize(0L);
        }
        this.templateCache = cacheBuilder.build((CacheLoader)new CacheLoader<String, Optional<Mustache>>(){

            public Optional<Mustache> load(String key) throws Exception {
                TemplateLocator locator;
                if (DefaultMustacheEngine.this.configuration.getTemplateLocators() == null || DefaultMustacheEngine.this.configuration.getTemplateLocators().isEmpty()) {
                    return Optional.absent();
                }
                Reader reader = null;
                Iterator<TemplateLocator> i$ = DefaultMustacheEngine.this.configuration.getTemplateLocators().iterator();
                while (i$.hasNext() && (reader = (locator = i$.next()).locate(key)) == null) {
                }
                if (reader == null) {
                    return Optional.absent();
                }
                return Optional.of((Object)DefaultMustacheEngine.this.parse(key, reader));
            }
        });
        this.parser = new ParserFactory().createParser(this);
        if (this.configuration.getBooleanPropertyValue(EngineConfigurationKey.PRECOMPILE_ALL_TEMPLATES).booleanValue()) {
            HashSet<String> templateNames = new HashSet<String>();
            for (TemplateLocator locator : this.configuration.getTemplateLocators()) {
                templateNames.addAll(locator.getAllIdentifiers());
            }
            for (String templateName : templateNames) {
                this.getTemplateFromCache(templateName);
            }
        }
    }

    @Override
    public Mustache getMustache(String templateName) {
        Checker.checkArgumentNotEmpty(templateName);
        return this.getTemplateFromCache(templateName);
    }

    @Override
    public Mustache compileMustache(String templateName, String templateContent) {
        Checker.checkArgumentNotEmpty(templateName);
        Checker.checkArgumentNotEmpty(templateContent);
        return this.parse(templateName, new StringReader(templateContent));
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void invalidateTemplateCache() {
        this.templateCache.invalidateAll();
    }

    public LoadingCache<String, Optional<Mustache>> getTemplateCache() {
        return this.templateCache;
    }

    private Mustache parse(String templateName, Reader reader) {
        ParsingHandler handler = new ParsingHandlerFactory().createParsingHandler();
        this.parser.parse(templateName, reader, handler);
        Mustache mustache = handler.getCompiledTemplate();
        if (this.configuration.getMustacheListeners() != null) {
            DefaultMustacheCompilationEvent event = new DefaultMustacheCompilationEvent(mustache);
            for (MustacheListener listener : this.configuration.getMustacheListeners()) {
                listener.compilationFinished(event);
            }
        }
        return mustache;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append(this.getClass().getName());
        builder.append("]");
        builder.append(Strings.LINE_SEPARATOR);
        builder.append(this.configuration.toString());
        return builder.toString();
    }

    private Mustache getTemplateFromCache(String templateName) {
        try {
            return (Mustache)((Optional)this.templateCache.get((Object)templateName)).orNull();
        }
        catch (ExecutionException e) {
            throw new MustacheException(MustacheProblem.TEMPLATE_LOADING_ERROR, (Throwable)e);
        }
    }

    private static class DefaultMustacheCompilationEvent
    implements MustacheCompilationEvent {
        private final Mustache mustache;

        public DefaultMustacheCompilationEvent(Mustache mustache) {
            this.mustache = mustache;
        }

        @Override
        public Mustache getMustache() {
            return this.mustache;
        }
    }
}

