/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trimou.engine.DefaultMustacheEngine;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.config.ConfigurationExtension;
import org.trimou.engine.config.ConfigurationKey;
import org.trimou.engine.config.EngineConfigurationKey;
import org.trimou.engine.listener.MustacheListener;
import org.trimou.engine.locale.LocaleSupport;
import org.trimou.engine.locator.TemplateLocator;
import org.trimou.engine.resolver.Resolver;
import org.trimou.engine.text.TextSupport;
import org.trimou.util.Checker;

public final class MustacheEngineBuilder
implements ConfigurationExtension.ConfigurationExtensionBuilder {
    private static final Logger logger = LoggerFactory.getLogger(MustacheEngineBuilder.class);
    private boolean omitServiceLoaderConfigurationExtensions = false;
    private Set<Resolver> resolvers = null;
    private Set<TemplateLocator> templateLocators = null;
    private Map<String, Object> globalData = null;
    private TextSupport textSupport = null;
    private LocaleSupport localeSupport = null;
    private Map<String, Object> properties = new HashMap<String, Object>(EngineConfigurationKey.values().length);
    private List<EngineBuiltCallback> engineReadyCallbacks = null;
    private List<MustacheListener> mustacheListeners;

    private MustacheEngineBuilder() {
    }

    public MustacheEngine build() {
        Package pack;
        DefaultMustacheEngine engine = new DefaultMustacheEngine(this);
        if (this.engineReadyCallbacks != null) {
            for (EngineBuiltCallback callback : this.engineReadyCallbacks) {
                callback.engineBuilt(engine);
            }
        }
        logger.info("Engine built {}\n{}", (Object)(StringUtils.isEmpty((CharSequence)(pack = MustacheEngine.class.getPackage()).getSpecificationVersion()) ? "SNAPSHOT" : pack.getSpecificationVersion()), (Object)((Object)engine).toString());
        this.performCleanup();
        return engine;
    }

    @Override
    public MustacheEngineBuilder addGlobalData(String name, Object value) {
        if (this.globalData == null) {
            this.globalData = new HashMap<String, Object>();
        }
        this.globalData.put(name, value);
        return this;
    }

    public MustacheEngineBuilder addTemplateLocator(TemplateLocator locator) {
        if (this.templateLocators == null) {
            this.templateLocators = new HashSet<TemplateLocator>();
        }
        this.templateLocators.add(locator);
        return this;
    }

    @Override
    public MustacheEngineBuilder addResolver(Resolver resolver) {
        if (this.resolvers == null) {
            this.resolvers = new HashSet<Resolver>();
        }
        this.resolvers.add(resolver);
        return this;
    }

    public MustacheEngineBuilder setProperty(String key, Object value) {
        this.properties.put(key, value);
        return this;
    }

    public MustacheEngineBuilder setProperty(ConfigurationKey configurationKey, Object value) {
        this.setProperty(configurationKey.get(), value);
        return this;
    }

    public MustacheEngineBuilder setTextSupport(TextSupport textSupport) {
        this.textSupport = textSupport;
        return this;
    }

    public MustacheEngineBuilder setLocaleSupport(LocaleSupport localeSupport) {
        this.localeSupport = localeSupport;
        return this;
    }

    public MustacheEngineBuilder registerCallback(EngineBuiltCallback callback) {
        Checker.checkArgumentNotNull(callback);
        if (this.engineReadyCallbacks == null) {
            this.engineReadyCallbacks = new ArrayList<EngineBuiltCallback>();
        }
        this.engineReadyCallbacks.add(callback);
        return this;
    }

    @Override
    public MustacheEngineBuilder addMustacheListener(MustacheListener listener) {
        Checker.checkArgumentNotNull(listener);
        if (this.mustacheListeners == null) {
            this.mustacheListeners = new ArrayList<MustacheListener>();
        }
        this.mustacheListeners.add(listener);
        return this;
    }

    public MustacheEngineBuilder omitServiceLoaderConfigurationExtensions() {
        this.omitServiceLoaderConfigurationExtensions = true;
        return this;
    }

    public static MustacheEngineBuilder newBuilder() {
        return new MustacheEngineBuilder();
    }

    public Set<TemplateLocator> getTemplateLocators() {
        return this.templateLocators;
    }

    public Set<Resolver> getResolvers() {
        return this.resolvers;
    }

    public Map<String, Object> getGlobalData() {
        return this.globalData;
    }

    public TextSupport getTextSupport() {
        return this.textSupport;
    }

    public LocaleSupport getLocaleSupport() {
        return this.localeSupport;
    }

    public boolean isOmitServiceLoaderConfigurationExtensions() {
        return this.omitServiceLoaderConfigurationExtensions;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public List<MustacheListener> getMustacheListeners() {
        return this.mustacheListeners;
    }

    private void performCleanup() {
        this.omitServiceLoaderConfigurationExtensions = false;
        this.resolvers = null;
        this.templateLocators = null;
        this.globalData = null;
        this.textSupport = null;
        this.localeSupport = null;
        this.properties.clear();
        this.engineReadyCallbacks = null;
    }

    public static interface EngineBuiltCallback {
        public void engineBuilt(MustacheEngine var1);
    }
}

