/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.resolver;

import java.lang.reflect.Array;
import org.trimou.engine.priority.Priorities;
import org.trimou.engine.resolver.IndexResolver;
import org.trimou.engine.resolver.ListIndexResolver;
import org.trimou.engine.resolver.ResolutionContext;

public class ArrayIndexResolver
extends IndexResolver {
    public static final int ARRAY_RESOLVER_PRIORITY = Priorities.after(ListIndexResolver.LIST_RESOLVER_PRIORITY);

    @Override
    public Object resolve(Object contextObject, String name, ResolutionContext context) {
        if (contextObject == null || this.notAnIndex(name) || !this.isArray(contextObject)) {
            return null;
        }
        Integer index = this.getIndexValue(name, Array.getLength(contextObject));
        if (index != null) {
            return Array.get(contextObject, index);
        }
        return null;
    }

    private boolean isArray(Object base) {
        return base.getClass().isArray();
    }

    @Override
    public int getPriority() {
        return ARRAY_RESOLVER_PRIORITY;
    }
}

