/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.resolver.i18n;

import java.text.NumberFormat;
import org.trimou.engine.priority.Priorities;
import org.trimou.engine.resolver.ArrayIndexResolver;
import org.trimou.engine.resolver.ResolutionContext;
import org.trimou.engine.resolver.i18n.LocaleAwareResolver;

public class NumberFormatResolver
extends LocaleAwareResolver {
    public static final int NUMBER_FORMAT_RESOLVER_PRIORITY = Priorities.after(ArrayIndexResolver.ARRAY_RESOLVER_PRIORITY);
    private static final String NAME_FORMAT = "format";
    private static final String NAME_FORMAT_PERCENT = "formatPercent";
    private static final String NAME_FORMAT_CURR = "formatCurrency";

    @Override
    public Object resolve(Object contextObject, String name, ResolutionContext context) {
        if (contextObject == null || !(contextObject instanceof Number)) {
            return null;
        }
        if (NAME_FORMAT.equals(name)) {
            return NumberFormat.getNumberInstance(this.localeSupport.getCurrentLocale()).format(contextObject);
        }
        if (NAME_FORMAT_PERCENT.equals(name)) {
            return NumberFormat.getPercentInstance(this.localeSupport.getCurrentLocale()).format(contextObject);
        }
        if (NAME_FORMAT_CURR.equals(name)) {
            return NumberFormat.getCurrencyInstance(this.localeSupport.getCurrentLocale()).format(contextObject);
        }
        return null;
    }

    @Override
    public int getPriority() {
        return NUMBER_FORMAT_RESOLVER_PRIORITY;
    }
}

