/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.util;

import java.beans.Introspector;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trimou.annotations.Internal;
import org.trimou.util.Checker;

@Internal
public final class Reflections {
    private static final Logger logger = LoggerFactory.getLogger(Reflections.class);
    private static final String GET_PREFIX = "get";
    private static final String IS_PREFIX = "is";

    private Reflections() {
    }

    public static Method findMethod(Class<?> clazz, String name) {
        Checker.checkArgumentNotNull(clazz);
        Checker.checkArgumentNotNull(name);
        Method found = null;
        for (Method method : Reflections.getMethods(clazz)) {
            String methodName;
            if (!Reflections.isMethodValid(method) || !(methodName = method.getName()).equals(name) && !Reflections.matchesPrefix(name, methodName, GET_PREFIX) && !Reflections.matchesPrefix(name, methodName, IS_PREFIX)) continue;
            found = method;
            break;
        }
        logger.debug("{} method {}found [type: {}]", new Object[]{name, found != null ? "" : "not ", clazz.getName()});
        return found;
    }

    private static Method[] getMethods(final Class<?> clazz) {
        return AccessController.doPrivileged(new PrivilegedAction<Method[]>(){

            @Override
            public Method[] run() {
                return clazz.getMethods();
            }
        });
    }

    public static Field findField(Class<?> clazz, String name) {
        Checker.checkArgumentNotNull(clazz);
        Checker.checkArgumentNotNull(name);
        Field found = null;
        for (Field field : Reflections.getFields(clazz)) {
            if (!field.getName().equals(name)) continue;
            found = field;
        }
        logger.debug("{} field {}found [type: {}]", new Object[]{name, found != null ? "" : "not ", clazz.getName()});
        return found;
    }

    private static Field[] getFields(final Class<?> clazz) {
        return AccessController.doPrivileged(new PrivilegedAction<Field[]>(){

            @Override
            public Field[] run() {
                return clazz.getFields();
            }
        });
    }

    public static boolean isMethodValid(Method method) {
        if (method == null) {
            return false;
        }
        if (!Modifier.isPublic(method.getModifiers()) || method.getParameterTypes().length != 0 || method.getReturnType().equals(Void.TYPE)) {
            return false;
        }
        return !Object.class.equals(method.getDeclaringClass());
    }

    private static boolean matchesPrefix(String name, String methodName, String prefix) {
        return methodName.startsWith(prefix) && Reflections.decapitalize(methodName, prefix).equals(name);
    }

    private static String decapitalize(String methodName, String prefix) {
        return Introspector.decapitalize(methodName.substring(prefix.length(), methodName.length()));
    }
}

