/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.locator;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trimou.engine.locator.FilePathTemplateLocator;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;
import org.trimou.util.Strings;

public class FileSystemTemplateLocator
extends FilePathTemplateLocator {
    private static final Logger logger = LoggerFactory.getLogger(FileSystemTemplateLocator.class);

    public FileSystemTemplateLocator(int priority, String rootPath) {
        super(priority, rootPath);
        this.checkRootDir();
    }

    public FileSystemTemplateLocator(int priority, String rootPath, String suffix) {
        super(priority, rootPath, suffix);
        this.checkRootDir();
    }

    @Override
    public Reader locateRealPath(String realPath) {
        try {
            File templateFile = new File(new File(this.getRootPath()), this.addSuffix(realPath));
            if (!this.isFileUsable(templateFile)) {
                return null;
            }
            logger.debug("Template located: {}", (Object)templateFile.getAbsolutePath());
            return new InputStreamReader((InputStream)new FileInputStream(templateFile), this.getDefaultFileEncoding());
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (UnsupportedEncodingException e) {
            throw new MustacheException(MustacheProblem.TEMPLATE_LOADING_ERROR, (Throwable)e);
        }
    }

    @Override
    protected String getRealPathSeparator() {
        return Strings.FILE_SEPARATOR;
    }

    @Override
    protected File getRootDir() {
        return new File(this.getRootPath());
    }
}

