/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.resolver.i18n;

import java.util.ResourceBundle;
import org.trimou.engine.priority.Priorities;
import org.trimou.engine.resolver.ArrayIndexResolver;
import org.trimou.engine.resolver.ResolutionContext;
import org.trimou.engine.resolver.i18n.LocaleAwareResolver;

public class ResourceBundleResolver
extends LocaleAwareResolver {
    private String baseName;

    public ResourceBundleResolver(String baseName) {
        super(Priorities.rightAfter(ArrayIndexResolver.ARRAY_RESOLVER_PRIORITY));
        this.baseName = baseName;
    }

    public ResourceBundleResolver(String baseName, int priority) {
        super(priority);
        this.baseName = baseName;
    }

    @Override
    public Object resolve(Object contextObject, String name, ResolutionContext context) {
        ResourceBundle bundle;
        if (contextObject == null && this.baseName.equals(name)) {
            return ResourceBundle.getBundle(this.baseName, this.localeSupport.getCurrentLocale());
        }
        if (contextObject != null && contextObject instanceof ResourceBundle && (bundle = (ResourceBundle)contextObject).containsKey(name)) {
            return bundle.getObject(name);
        }
        return null;
    }
}

