/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.util;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.trimou.annotations.Internal;
import org.trimou.util.StringBuilderWriter;

@Internal
public final class IOUtils {
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    public static String toString(Reader input) throws IOException {
        return IOUtils.toString(input, 4096);
    }

    public static String toString(Reader input, int bufferSize) throws IOException {
        StringBuilderWriter writer = new StringBuilderWriter();
        IOUtils.copy(input, writer, bufferSize);
        return writer.toString();
    }

    public static void copy(Reader input, Writer output, int bufferSize) throws IOException {
        char[] buffer = new char[bufferSize];
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
        output.flush();
    }
}

