/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine;

import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trimou.Mustache;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.engine.config.Configuration;
import org.trimou.engine.config.ConfigurationFactory;
import org.trimou.engine.config.EngineConfigurationKey;
import org.trimou.engine.listener.MustacheCompilationEvent;
import org.trimou.engine.listener.MustacheListener;
import org.trimou.engine.listener.MustacheParsingEvent;
import org.trimou.engine.locator.TemplateLocator;
import org.trimou.engine.parser.ParserFactory;
import org.trimou.engine.parser.ParsingHandler;
import org.trimou.engine.parser.ParsingHandlerFactory;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;
import org.trimou.util.Checker;
import org.trimou.util.Strings;

class DefaultMustacheEngine
implements MustacheEngine,
RemovalListener<String, Mustache> {
    private static final Logger logger = LoggerFactory.getLogger(DefaultMustacheEngine.class);
    private LoadingCache<String, Optional<Mustache>> templateCache;
    private Configuration configuration;
    private ParserFactory parserFactory;
    private ParsingHandlerFactory parsingHandlerFactory;

    DefaultMustacheEngine() {
    }

    DefaultMustacheEngine(MustacheEngineBuilder builder) {
        this.configuration = new ConfigurationFactory().createConfiguration(builder);
        this.parserFactory = new ParserFactory();
        this.parsingHandlerFactory = new ParsingHandlerFactory();
        if (this.configuration.getBooleanPropertyValue(EngineConfigurationKey.DEBUG_MODE).booleanValue()) {
            logger.warn("Attention! Debug mode enabled: template cache disabled, additional logging enabled");
        } else if (this.configuration.getBooleanPropertyValue(EngineConfigurationKey.TEMPLATE_CACHE_ENABLED).booleanValue()) {
            this.buildTemplateCache();
            if (this.configuration.getBooleanPropertyValue(EngineConfigurationKey.PRECOMPILE_ALL_TEMPLATES).booleanValue()) {
                this.precompileTemplates();
            }
        } else {
            logger.info("Template cache explicitly disabled!");
        }
    }

    @Override
    public Mustache getMustache(String templateId) {
        Checker.checkArgumentNotEmpty(templateId);
        return this.templateCache != null ? this.getTemplateFromCache(templateId) : this.locateAndParse(templateId);
    }

    @Override
    public Mustache compileMustache(String templateId, String templateContent) {
        Checker.checkArgumentNotEmpty(templateId);
        Checker.checkArgumentNotEmpty(templateContent);
        return this.parse(templateId, new StringReader(templateContent));
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void invalidateTemplateCache() {
        this.templateCache.invalidateAll();
    }

    public LoadingCache<String, Optional<Mustache>> getTemplateCache() {
        return this.templateCache;
    }

    public void onRemoval(RemovalNotification<String, Mustache> notification) {
        logger.debug("Removed template [templateId: {}, cause: {}]", notification.getKey(), (Object)notification.getCause());
    }

    private void buildTemplateCache() {
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder();
        long expirationTimeout = this.configuration.getLongPropertyValue(EngineConfigurationKey.TEMPLATE_CACHE_EXPIRATION_TIMEOUT);
        if (expirationTimeout > 0L) {
            logger.info("Template cache expiration timeout set: {} seconds", (Object)expirationTimeout);
            cacheBuilder.expireAfterWrite(expirationTimeout, TimeUnit.SECONDS);
            cacheBuilder.removalListener((RemovalListener)this);
        }
        this.templateCache = cacheBuilder.build((CacheLoader)new CacheLoader<String, Optional<Mustache>>(){

            public Optional<Mustache> load(String key) throws Exception {
                return Optional.fromNullable((Object)DefaultMustacheEngine.this.locateAndParse(key));
            }
        });
    }

    private void precompileTemplates() {
        HashSet<String> templateNames = new HashSet<String>();
        for (TemplateLocator locator : this.configuration.getTemplateLocators()) {
            templateNames.addAll(locator.getAllIdentifiers());
        }
        for (String templateName : templateNames) {
            this.getTemplateFromCache(templateName);
        }
    }

    private Mustache parse(String templateId, Reader reader) {
        ParsingHandler handler = this.parsingHandlerFactory.createParsingHandler();
        reader = this.notifyListenersBeforeParsing(templateId, reader);
        this.parserFactory.createParser(this).parse(templateId, reader, handler);
        Mustache mustache = handler.getCompiledTemplate();
        this.notifyListenersAfterCompilation(mustache);
        return mustache;
    }

    private Reader locate(String templateId) {
        TemplateLocator locator;
        if (this.configuration.getTemplateLocators() == null || this.configuration.getTemplateLocators().isEmpty()) {
            return null;
        }
        Reader reader = null;
        Iterator<TemplateLocator> i$ = this.configuration.getTemplateLocators().iterator();
        while (i$.hasNext() && (reader = (locator = i$.next()).locate(templateId)) == null) {
        }
        return reader;
    }

    private Mustache locateAndParse(String templateId) {
        Reader reader = this.locate(templateId);
        return reader != null ? this.parse(templateId, reader) : null;
    }

    private Reader notifyListenersBeforeParsing(String templateName, Reader reader) {
        if (this.configuration.getMustacheListeners() != null) {
            DefaultMustacheParsingEvent event = new DefaultMustacheParsingEvent(templateName, reader);
            for (MustacheListener listener : this.configuration.getMustacheListeners()) {
                listener.parsingStarted(event);
            }
            return event.getMustacheContents();
        }
        return reader;
    }

    private void notifyListenersAfterCompilation(Mustache mustache) {
        if (this.configuration.getMustacheListeners() != null) {
            DefaultMustacheCompilationEvent event = new DefaultMustacheCompilationEvent(mustache);
            for (MustacheListener listener : this.configuration.getMustacheListeners()) {
                listener.compilationFinished(event);
            }
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append(this.getClass().getName());
        builder.append("]");
        builder.append(Strings.LINE_SEPARATOR);
        builder.append(this.configuration.toString());
        return builder.toString();
    }

    private Mustache getTemplateFromCache(String templateName) {
        try {
            return (Mustache)((Optional)this.templateCache.get((Object)templateName)).orNull();
        }
        catch (ExecutionException e) {
            throw new MustacheException(MustacheProblem.TEMPLATE_LOADING_ERROR, (Throwable)e);
        }
    }

    private static class DefaultMustacheParsingEvent
    implements MustacheParsingEvent {
        private final String mustacheName;
        private Reader reader;

        public DefaultMustacheParsingEvent(String mustacheName, Reader reader) {
            this.mustacheName = mustacheName;
            this.reader = reader;
        }

        @Override
        public String getMustacheName() {
            return this.mustacheName;
        }

        @Override
        public Reader getMustacheContents() {
            return this.reader;
        }

        @Override
        public void setMustacheContents(Reader reader) {
            this.reader = reader;
        }
    }

    private static class DefaultMustacheCompilationEvent
    implements MustacheCompilationEvent {
        private final Mustache mustache;

        public DefaultMustacheCompilationEvent(Mustache mustache) {
            this.mustache = mustache;
        }

        @Override
        public Mustache getMustache() {
            return this.mustache;
        }
    }
}

