/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.config;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.engine.config.Configuration;
import org.trimou.engine.config.ConfigurationAware;
import org.trimou.engine.config.ConfigurationExtension;
import org.trimou.engine.config.ConfigurationKey;
import org.trimou.engine.config.ConfigurationProperties;
import org.trimou.engine.config.EngineConfigurationKey;
import org.trimou.engine.listener.MustacheListener;
import org.trimou.engine.locale.LocaleSupport;
import org.trimou.engine.locale.LocaleSupportFactory;
import org.trimou.engine.locator.TemplateLocator;
import org.trimou.engine.priority.HighPriorityComparator;
import org.trimou.engine.resolver.Resolver;
import org.trimou.engine.text.TextSupport;
import org.trimou.engine.text.TextSupportFactory;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;
import org.trimou.util.SecurityActions;
import org.trimou.util.Strings;

class DefaultConfiguration
implements Configuration {
    private static final String RESOURCE_FILE = "/trimou.properties";
    private List<TemplateLocator> templateLocators = null;
    private List<Resolver> resolvers = null;
    private Map<String, Object> globalData = null;
    private TextSupport textSupport;
    private LocaleSupport localeSupport;
    private Map<String, Object> properties;
    private List<MustacheListener> mustacheListeners;

    DefaultConfiguration(MustacheEngineBuilder builder) {
        Map<String, Object> globalData;
        if (!builder.isOmitServiceLoaderConfigurationExtensions()) {
            Iterator<ConfigurationExtension> iterator = ServiceLoader.load(ConfigurationExtension.class).iterator();
            while (iterator.hasNext()) {
                iterator.next().register(builder);
            }
        }
        this.identifyResolvers(builder);
        this.identifyTextSupport(builder);
        this.identifyLocaleSupport(builder);
        this.identifyTemplateLocators(builder);
        List<MustacheListener> listeners = builder.buildMustacheListeners();
        if (!listeners.isEmpty()) {
            this.mustacheListeners = listeners;
        }
        if (!(globalData = builder.buildGlobalData()).isEmpty()) {
            this.globalData = globalData;
        }
        this.initializeProperties(builder);
        this.initializeConfigurationAwareComponents();
    }

    @Override
    public List<Resolver> getResolvers() {
        return this.resolvers;
    }

    @Override
    public Map<String, Object> getGlobalData() {
        return this.globalData;
    }

    @Override
    public List<TemplateLocator> getTemplateLocators() {
        return this.templateLocators;
    }

    @Override
    public TextSupport getTextSupport() {
        return this.textSupport;
    }

    @Override
    public LocaleSupport getLocaleSupport() {
        return this.localeSupport;
    }

    @Override
    public List<MustacheListener> getMustacheListeners() {
        return this.mustacheListeners;
    }

    @Override
    public <T extends ConfigurationKey> Long getLongPropertyValue(T configurationKey) {
        Long value = (Long)this.properties.get(configurationKey.get());
        if (value == null) {
            value = (Long)configurationKey.getDefaultValue();
        }
        return value;
    }

    @Override
    public <T extends ConfigurationKey> Integer getIntegerPropertyValue(T configurationKey) {
        Integer value = (Integer)this.properties.get(configurationKey.get());
        if (value == null) {
            value = (Integer)configurationKey.getDefaultValue();
        }
        return value;
    }

    @Override
    public <T extends ConfigurationKey> String getStringPropertyValue(T configurationKey) {
        Object value = this.properties.get(configurationKey.get());
        if (value == null) {
            value = configurationKey.getDefaultValue();
        }
        return value.toString();
    }

    @Override
    public <T extends ConfigurationKey> Boolean getBooleanPropertyValue(T configurationKey) {
        Boolean value = (Boolean)this.properties.get(configurationKey.get());
        if (value == null) {
            value = (Boolean)configurationKey.getDefaultValue();
        }
        return value;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("----------");
        builder.append(Strings.LINE_SEPARATOR);
        builder.append("[");
        builder.append(this.getClass().getName());
        builder.append("]");
        if (this.templateLocators != null) {
            builder.append(Strings.LINE_SEPARATOR);
            builder.append("----------");
            builder.append(Strings.LINE_SEPARATOR);
            builder.append("[Template locators]");
            for (TemplateLocator templateLocator : this.templateLocators) {
                builder.append(Strings.LINE_SEPARATOR);
                builder.append(templateLocator.toString());
            }
        }
        if (this.resolvers != null) {
            builder.append(Strings.LINE_SEPARATOR);
            builder.append("----------");
            builder.append(Strings.LINE_SEPARATOR);
            builder.append("[Resolvers]");
            for (Resolver resolver : this.resolvers) {
                builder.append(Strings.LINE_SEPARATOR);
                builder.append(resolver.toString());
            }
        }
        builder.append(Strings.LINE_SEPARATOR);
        builder.append("----------");
        builder.append(Strings.LINE_SEPARATOR);
        builder.append("[Properties]");
        for (Map.Entry entry : this.properties.entrySet()) {
            builder.append(Strings.LINE_SEPARATOR);
            builder.append((String)entry.getKey());
            builder.append("=");
            builder.append(entry.getValue());
        }
        return builder.toString();
    }

    private void initializeConfigurationAwareComponents() {
        for (ConfigurationAware component : this.getConfigurationAwareComponents()) {
            component.init(this);
        }
    }

    private void identifyResolvers(MustacheEngineBuilder builder) {
        Set<Resolver> builderResolvers = builder.buildResolvers();
        if (!builderResolvers.isEmpty()) {
            this.resolvers = new ArrayList<Resolver>();
            this.resolvers.addAll(builderResolvers);
            Collections.sort(this.resolvers, new HighPriorityComparator());
            this.resolvers = ImmutableList.copyOf(this.resolvers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeProperties(MustacheEngineBuilder engineBuilder) {
        Properties resourceProperties;
        Map<String, Object> builderProperties;
        ImmutableMap.Builder builder;
        Set<ConfigurationKey> keysToProcess;
        block11: {
            keysToProcess = this.getConfigurationKeysToProcess();
            builder = ImmutableMap.builder();
            builderProperties = engineBuilder.buildProperties();
            resourceProperties = new Properties();
            try {
                InputStream in = this.getClass().getResourceAsStream(RESOURCE_FILE);
                if (in == null) break block11;
                try {
                    resourceProperties.load(in);
                }
                finally {
                    in.close();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        for (ConfigurationKey configKey : keysToProcess) {
            String key = configKey.get();
            Object value = builderProperties.get(key);
            if (value == null && (value = SecurityActions.getSystemProperty(key)) == null) {
                value = resourceProperties.getProperty(key);
            }
            if (value != null) {
                try {
                    value = ConfigurationProperties.convertConfigValue(configKey.getDefaultValue().getClass(), value);
                }
                catch (Exception e) {
                    throw new MustacheException(MustacheProblem.CONFIG_PROPERTY_INVALID_VALUE, (Throwable)e);
                }
            } else {
                value = configKey.getDefaultValue();
            }
            builder.put((Object)key, value);
        }
        this.properties = builder.build();
    }

    private Set<ConfigurationKey> getConfigurationKeysToProcess() {
        HashSet<ConfigurationKey> keys = new HashSet<ConfigurationKey>();
        for (EngineConfigurationKey key : EngineConfigurationKey.values()) {
            keys.add(key);
        }
        for (ConfigurationAware component : this.getConfigurationAwareComponents()) {
            keys.addAll(component.getConfigurationKeys());
        }
        return keys;
    }

    private void identifyTextSupport(MustacheEngineBuilder builder) {
        this.textSupport = builder.getTextSupport() != null ? builder.getTextSupport() : new TextSupportFactory().createTextSupport();
    }

    private void identifyLocaleSupport(MustacheEngineBuilder builder) {
        this.localeSupport = builder.getLocaleSupport() != null ? builder.getLocaleSupport() : new LocaleSupportFactory().createLocateSupport();
    }

    private void identifyTemplateLocators(MustacheEngineBuilder builder) {
        Set<TemplateLocator> builderTemplateLocators = builder.buildTemplateLocators();
        if (!builderTemplateLocators.isEmpty()) {
            ArrayList<TemplateLocator> locators = new ArrayList<TemplateLocator>(builder.buildTemplateLocators());
            Collections.sort(locators, new HighPriorityComparator());
            this.templateLocators = ImmutableList.copyOf(locators);
        }
    }

    private Set<ConfigurationAware> getConfigurationAwareComponents() {
        HashSet<ConfigurationAware> components = new HashSet<ConfigurationAware>();
        components.addAll(this.resolvers);
        if (this.templateLocators != null) {
            components.addAll(this.templateLocators);
        }
        if (this.mustacheListeners != null) {
            components.addAll(this.mustacheListeners);
        }
        components.add(this.localeSupport);
        components.add(this.textSupport);
        return components;
    }
}

