/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.context;

import org.trimou.annotations.Internal;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.context.DebugExecutionContext;
import org.trimou.engine.context.DefaultExecutionContext;
import org.trimou.engine.context.ExecutionContext;

@Internal
public class ExecutionContextBuilder {
    private final MustacheEngine engine;
    private Object data;

    public ExecutionContextBuilder(MustacheEngine engine) {
        this.engine = engine;
    }

    public ExecutionContextBuilder withData(Object data) {
        this.data = data;
        return this;
    }

    public ExecutionContext build(boolean debugMode) {
        DefaultExecutionContext context = null;
        context = debugMode ? new DebugExecutionContext(this.engine.getConfiguration()) : new DefaultExecutionContext(this.engine.getConfiguration());
        if (this.engine.getConfiguration().getGlobalData() != null) {
            context.push(ExecutionContext.TargetStack.CONTEXT, this.engine.getConfiguration().getGlobalData());
        }
        if (this.data != null) {
            context.push(ExecutionContext.TargetStack.CONTEXT, this.data);
        }
        return context;
    }
}

