/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.parser;

import org.trimou.engine.config.EngineConfigurationKey;

final class Delimiters {
    private String start;
    private String end;

    Delimiters(String startDelimiter, String endDelimiter) {
        this.reset(startDelimiter, endDelimiter);
    }

    protected void setNewValues(String startDelimiter, String endDelimiter) {
        this.reset(startDelimiter, endDelimiter);
    }

    private void reset(String startDelimiter, String endDelimiter) {
        this.start = startDelimiter;
        this.end = endDelimiter;
    }

    public char getStart(int index) {
        return this.start.charAt(index);
    }

    public boolean isStartOver(int index) {
        return index == this.start.length() - 1;
    }

    public String getStartPart(int index) {
        return this.start.substring(0, index);
    }

    public char getEnd(int index) {
        return this.end.charAt(index);
    }

    public boolean isEndOver(int index) {
        return index == this.end.length() - 1;
    }

    public String getEndPart(int index) {
        return this.end.substring(0, index);
    }

    public boolean hasDefaultDelimitersSet() {
        return EngineConfigurationKey.START_DELIMITER.getDefaultValue().equals(this.start) && EngineConfigurationKey.END_DELIMITER.getDefaultValue().equals(this.end);
    }
}

