/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.segment;

import java.io.IOException;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.config.Configuration;
import org.trimou.engine.config.EngineConfigurationKey;
import org.trimou.engine.segment.Origin;
import org.trimou.engine.segment.Segment;
import org.trimou.engine.segment.TemplateSegment;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;

abstract class AbstractSegment
implements Segment {
    private final Origin origin;
    private final String text;

    public AbstractSegment(String text, Origin origin) {
        this.text = text;
        this.origin = origin;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public Origin getOrigin() {
        return this.origin;
    }

    @Override
    public String getLiteralBlock() {
        return this.getTagLiteral(this.getText());
    }

    @Override
    public void performPostProcessing() {
    }

    public String toString() {
        return String.format("%s:%s %s", new Object[]{this.getType(), this.getSegmentName(), this.getOrigin()});
    }

    public TemplateSegment getTemplate() {
        return this.origin != null ? this.origin.getTemplate() : null;
    }

    protected boolean isReadOnly() {
        return this.getTemplate().isReadOnly();
    }

    protected MustacheEngine getEngine() {
        return this.getTemplate().getEngine();
    }

    protected Configuration getEngineConfiguration() {
        return this.getEngine().getConfiguration();
    }

    protected String getDefaultStartDelimiter() {
        return this.getEngineConfiguration().getStringPropertyValue(EngineConfigurationKey.START_DELIMITER);
    }

    protected String getDefaultEndDelimiter() {
        return this.getEngineConfiguration().getStringPropertyValue(EngineConfigurationKey.END_DELIMITER);
    }

    protected String getTagLiteral(String content) {
        return this.getDefaultStartDelimiter() + content + this.getDefaultEndDelimiter();
    }

    protected String getSegmentName() {
        return "";
    }

    protected void append(Appendable appendable, String text) {
        try {
            appendable.append(text);
        }
        catch (IOException e) {
            throw new MustacheException(MustacheProblem.RENDER_IO_ERROR, (Throwable)e);
        }
    }

    protected void checkModificationAllowed() {
        if (this.isReadOnly()) {
            throw new MustacheException(MustacheProblem.TEMPLATE_MODIFICATION_NOT_ALLOWED, this.toString(), new Object[0]);
        }
    }
}

