/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.segment;

import org.trimou.annotations.Internal;
import org.trimou.engine.context.ExecutionContext;
import org.trimou.engine.segment.AbstractSectionSegment;
import org.trimou.engine.segment.ExtendSectionSegment;
import org.trimou.engine.segment.Origin;
import org.trimou.engine.segment.Segment;
import org.trimou.engine.segment.SegmentType;
import org.trimou.engine.segment.TemplateSegment;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;

@Internal
public class ExtendSegment
extends AbstractSectionSegment {
    public ExtendSegment(String text, Origin origin) {
        super(text, origin);
    }

    @Override
    public SegmentType getType() {
        return SegmentType.EXTEND;
    }

    @Override
    public void execute(Appendable appendable, ExecutionContext context) {
        TemplateSegment extended = (TemplateSegment)this.getEngine().getMustache(this.getText());
        if (extended == null) {
            throw new MustacheException(MustacheProblem.RENDER_INVALID_EXTEND_KEY, "No template to extend found for the given key: %s %s", this.getText(), this.getOrigin());
        }
        context.push(ExecutionContext.TargetStack.TEMPLATE_INVOCATION, extended);
        for (Segment extendSection : this) {
            context.addDefiningSection(extendSection.getText(), (ExtendSectionSegment)extendSection);
        }
        extended.execute(appendable, context);
        context.pop(ExecutionContext.TargetStack.TEMPLATE_INVOCATION);
    }

    @Override
    public void addSegment(Segment segment) {
        if (SegmentType.EXTEND_SECTION.equals((Object)segment.getType())) {
            super.addSegment(segment);
        }
    }
}

