/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.segment;

import java.lang.reflect.Array;
import java.util.Iterator;
import org.trimou.annotations.Internal;
import org.trimou.engine.context.ExecutionContext;
import org.trimou.engine.context.ValueWrapper;
import org.trimou.engine.segment.AbstractSectionSegment;
import org.trimou.engine.segment.IterationMeta;
import org.trimou.engine.segment.Lambdas;
import org.trimou.engine.segment.Origin;
import org.trimou.engine.segment.SegmentType;
import org.trimou.engine.segment.TemplateSegment;
import org.trimou.lambda.Lambda;

@Internal
public class SectionSegment
extends AbstractSectionSegment {
    public SectionSegment(String text, Origin origin) {
        super(text, origin);
    }

    @Override
    public SegmentType getType() {
        return SegmentType.SECTION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Appendable appendable, ExecutionContext context) {
        ValueWrapper value = context.getValue(this.getText());
        try {
            if (value.isNull()) {
                return;
            }
            this.processValue(appendable, context, value.get());
        }
        finally {
            value.release();
        }
    }

    private void processValue(Appendable appendable, ExecutionContext context, Object value) {
        if (value instanceof Boolean) {
            if (((Boolean)value).booleanValue()) {
                super.execute(appendable, context);
            }
        } else if (value instanceof Iterable) {
            this.processIterable(appendable, context, value);
        } else if (value.getClass().isArray()) {
            this.processArray(appendable, context, value);
        } else if (value instanceof Lambda) {
            this.processLambda(appendable, context, value);
        } else {
            context.push(ExecutionContext.TargetStack.CONTEXT, value);
            super.execute(appendable, context);
            context.pop(ExecutionContext.TargetStack.CONTEXT);
        }
    }

    private void processIterable(Appendable appendable, ExecutionContext context, Object value) {
        Iterator iterator = ((Iterable)value).iterator();
        if (!iterator.hasNext()) {
            return;
        }
        IterationMeta meta = new IterationMeta(iterator);
        context.push(ExecutionContext.TargetStack.CONTEXT, meta);
        while (iterator.hasNext()) {
            context.push(ExecutionContext.TargetStack.CONTEXT, iterator.next());
            super.execute(appendable, context);
            context.pop(ExecutionContext.TargetStack.CONTEXT);
            meta.nextIteration();
        }
        context.pop(ExecutionContext.TargetStack.CONTEXT);
    }

    private void processArray(Appendable appendable, ExecutionContext context, Object value) {
        int length = Array.getLength(value);
        if (length < 1) {
            return;
        }
        IterationMeta meta = new IterationMeta(length);
        context.push(ExecutionContext.TargetStack.CONTEXT, meta);
        for (int i = 0; i < length; ++i) {
            context.push(ExecutionContext.TargetStack.CONTEXT, Array.get(value, i));
            super.execute(appendable, context);
            context.pop(ExecutionContext.TargetStack.CONTEXT);
            meta.nextIteration();
        }
        context.pop(ExecutionContext.TargetStack.CONTEXT);
    }

    private void processLambda(Appendable appendable, ExecutionContext context, Object value) {
        String input;
        Lambda lambda = (Lambda)value;
        switch (lambda.getInputType()) {
            case LITERAL: {
                input = this.getContainingLiteralBlock();
                break;
            }
            case PROCESSED: {
                StringBuilder processed = new StringBuilder();
                super.execute(processed, context);
                input = processed.toString();
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported lambda input type");
            }
        }
        String returnValue = lambda.invoke(input);
        if (lambda.isReturnValueInterpolated()) {
            TemplateSegment temp = (TemplateSegment)this.getEngine().compileMustache(Lambdas.constructLambdaOneoffTemplateName(this), returnValue);
            temp.execute(appendable, context);
        } else {
            this.append(appendable, returnValue);
        }
    }
}

