/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.segment;

import com.google.common.collect.Lists;
import java.util.List;
import org.trimou.Mustache;
import org.trimou.annotations.Internal;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.config.EngineConfigurationKey;
import org.trimou.engine.context.ExecutionContext;
import org.trimou.engine.context.ExecutionContextBuilder;
import org.trimou.engine.listener.MustacheListener;
import org.trimou.engine.listener.MustacheRenderingEvent;
import org.trimou.engine.resource.AbstractReleaseCallbackContainer;
import org.trimou.engine.segment.AbstractContainerSegment;
import org.trimou.engine.segment.SegmentType;
import org.trimou.engine.segment.Segments;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;

@Internal
public class TemplateSegment
extends AbstractContainerSegment
implements Mustache {
    private final MustacheEngine engine;
    private boolean readOnly = false;
    private boolean debugMode;

    public TemplateSegment(String text, MustacheEngine engine) {
        super(text, null);
        this.engine = engine;
        this.debugMode = engine.getConfiguration().getBooleanPropertyValue(EngineConfigurationKey.DEBUG_MODE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(Appendable appendable, Object data) {
        this.checkIsReady();
        DefaultMustacheRenderingEvent event = new DefaultMustacheRenderingEvent(this.getText());
        try {
            this.renderingStarted(event);
            ExecutionContext context = new ExecutionContextBuilder(this.engine).withData(data).build(this.debugMode);
            context.push(ExecutionContext.TargetStack.TEMPLATE_INVOCATION, this);
            super.execute(appendable, context);
            this.renderingFinished(event);
        }
        finally {
            event.release();
        }
    }

    @Override
    public String render(Object data) {
        StringBuilder builder = new StringBuilder();
        this.render(builder, data);
        return builder.toString();
    }

    @Override
    public SegmentType getType() {
        return SegmentType.TEMPLATE;
    }

    @Override
    public String getLiteralBlock() {
        return this.getContainingLiteralBlock();
    }

    @Override
    public String getName() {
        return this.getText();
    }

    @Override
    public void performPostProcessing() {
        if (this.engine.getConfiguration().getBooleanPropertyValue(EngineConfigurationKey.REMOVE_STANDALONE_LINES).booleanValue()) {
            Segments.removeStandaloneLines(this);
        }
        if (this.engine.getConfiguration().getBooleanPropertyValue(EngineConfigurationKey.REMOVE_UNNECESSARY_SEGMENTS).booleanValue()) {
            Segments.removeUnnecessarySegments(this);
        }
        super.performPostProcessing();
        this.readOnly = true;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public String toString() {
        return String.format("%s: %s]", new Object[]{this.getType(), this.getName()});
    }

    @Override
    protected MustacheEngine getEngine() {
        return this.engine;
    }

    private void renderingStarted(MustacheRenderingEvent event) {
        List<MustacheListener> listeners = this.engine.getConfiguration().getMustacheListeners();
        if (listeners != null) {
            for (MustacheListener listener : listeners) {
                listener.renderingStarted(event);
            }
        }
    }

    private void renderingFinished(MustacheRenderingEvent event) {
        List<MustacheListener> listeners = this.engine.getConfiguration().getMustacheListeners();
        if (listeners != null) {
            for (MustacheListener listener : Lists.reverse(listeners)) {
                listener.renderingFinished(event);
            }
        }
    }

    private void checkIsReady() {
        if (!this.isReadOnly()) {
            throw new MustacheException(MustacheProblem.TEMPLATE_NOT_READY, "Template %s is not ready yet", this.getName());
        }
    }

    private static final class DefaultMustacheRenderingEvent
    extends AbstractReleaseCallbackContainer
    implements MustacheRenderingEvent {
        private final String mustacheName;

        public DefaultMustacheRenderingEvent(String mustacheName) {
            this.mustacheName = mustacheName;
        }

        @Override
        public String getMustacheName() {
            return this.mustacheName;
        }
    }
}

