/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.locator;

import java.io.File;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trimou.engine.locator.PathTemplateLocator;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;

public abstract class FilePathTemplateLocator
extends PathTemplateLocator<File> {
    private static final Logger logger = LoggerFactory.getLogger(FilePathTemplateLocator.class);

    public FilePathTemplateLocator(int priority, String rootPath, String suffix) {
        super(priority, rootPath, suffix);
    }

    public FilePathTemplateLocator(int priority, String rootPath) {
        super(priority, rootPath);
    }

    @Override
    public Reader locate(String filePath) {
        return this.locateRealPath(this.toRealPath(filePath));
    }

    @Override
    public Set<String> getAllIdentifiers() {
        List<File> files = this.listFiles(this.getRootDir());
        if (files.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> identifiers = new HashSet<String>();
        for (File file : files) {
            if (!this.isFileUsable(file)) continue;
            String id = this.stripSuffix(this.constructVirtualPath(file));
            identifiers.add(id);
            logger.debug("Template available: {}", (Object)id);
        }
        return identifiers;
    }

    @Override
    protected String constructVirtualPath(File source) {
        File rootDir = this.getRootDir();
        File parent = source.getParentFile();
        ArrayList<String> parts = new ArrayList<String>();
        if (parent == null) {
            throw new IllegalStateException("Unable to construct virtual path - no parent directory found");
        }
        parts.add(source.getName());
        while (!rootDir.equals(parent)) {
            parts.add(parent.getName());
            parent = parent.getParentFile();
        }
        Collections.reverse(parts);
        StringBuilder name = new StringBuilder();
        Iterator iterator = parts.iterator();
        while (iterator.hasNext()) {
            name.append((String)iterator.next());
            if (!iterator.hasNext()) continue;
            name.append(this.getVirtualPathSeparator());
        }
        return name.toString();
    }

    protected abstract File getRootDir();

    protected abstract Reader locateRealPath(String var1);

    protected List<File> listFiles(File dir) {
        ArrayList<File> files = new ArrayList<File>();
        if (dir.isDirectory()) {
            for (File file : dir.listFiles()) {
                if (file.isDirectory()) {
                    files.addAll(this.listFiles(file));
                    continue;
                }
                if (!file.isFile() || this.getSuffix() != null && !file.getName().endsWith(this.getSuffix())) continue;
                files.add(file);
            }
        }
        return files;
    }

    protected boolean isDirectoryUsable(File dir) {
        if (!dir.exists()) {
            logger.warn("Dir not usable - does not exist: {}", (Object)dir);
            return false;
        }
        if (!dir.canRead()) {
            logger.warn("Dir not usable - cannot read: {}", (Object)dir);
            return false;
        }
        if (!dir.isDirectory()) {
            logger.warn("Dir not usable - not a directory: {}", (Object)dir);
            return false;
        }
        return true;
    }

    protected boolean isFileUsable(File file) {
        if (!file.exists()) {
            logger.warn("File not usable - does not exist: {}", (Object)file);
            return false;
        }
        if (!file.canRead()) {
            logger.warn("File not usable - cannot read: {}", (Object)file);
            return false;
        }
        if (!file.isFile()) {
            logger.warn("File not usable - not a normal file: {}", (Object)file);
            return false;
        }
        return true;
    }

    protected void checkRootDir() {
        File rootDir = this.getRootDir();
        if (!this.isDirectoryUsable(rootDir)) {
            throw new MustacheException(MustacheProblem.TEMPLATE_LOCATOR_INVALID_CONFIGURATION, "Invalid root dir: %s", rootDir);
        }
    }
}

