/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.segment;

import java.io.IOException;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.MustacheTagInfo;
import org.trimou.engine.MustacheTagType;
import org.trimou.engine.config.Configuration;
import org.trimou.engine.config.EngineConfigurationKey;
import org.trimou.engine.segment.Origin;
import org.trimou.engine.segment.Segment;
import org.trimou.engine.segment.TemplateSegment;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;

abstract class AbstractSegment
implements Segment {
    private final Origin origin;
    private final String text;
    private MustacheTagInfo info = null;

    public AbstractSegment(String text, Origin origin) {
        this.text = text;
        this.origin = origin;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public Origin getOrigin() {
        return this.origin;
    }

    @Override
    public synchronized MustacheTagInfo getTagInfo() {
        if (this.info == null) {
            this.info = new DefaultSegmentInfo(this.getTagType(), this.getText(), this.getOrigin().getLine(), this.getOrigin().getTemplateName());
        }
        return this.info;
    }

    @Override
    public String getLiteralBlock() {
        return this.getTagLiteral(this.getText());
    }

    @Override
    public void performPostProcessing() {
    }

    public String toString() {
        return String.format("%s:%s %s", new Object[]{this.getType(), this.getSegmentName(), this.getOrigin()});
    }

    public TemplateSegment getTemplate() {
        return this.origin != null ? this.origin.getTemplate() : null;
    }

    protected boolean isReadOnly() {
        return this.getTemplate().isReadOnly();
    }

    protected MustacheEngine getEngine() {
        return this.getTemplate().getEngine();
    }

    protected Configuration getEngineConfiguration() {
        return this.getEngine().getConfiguration();
    }

    protected String getDefaultStartDelimiter() {
        return this.getEngineConfiguration().getStringPropertyValue(EngineConfigurationKey.START_DELIMITER);
    }

    protected String getDefaultEndDelimiter() {
        return this.getEngineConfiguration().getStringPropertyValue(EngineConfigurationKey.END_DELIMITER);
    }

    protected String getTagLiteral(String content) {
        return this.getDefaultStartDelimiter() + content + this.getDefaultEndDelimiter();
    }

    protected boolean isHandlebarsSupportEnabled() {
        return this.getEngineConfiguration().getBooleanPropertyValue(EngineConfigurationKey.HANDLEBARS_SUPPORT_ENABLED);
    }

    protected String getSegmentName() {
        return "";
    }

    protected void append(Appendable appendable, String text) {
        try {
            appendable.append(text);
        }
        catch (IOException e) {
            throw new MustacheException(MustacheProblem.RENDER_IO_ERROR, (Throwable)e);
        }
    }

    protected void checkModificationAllowed() {
        if (this.isReadOnly()) {
            throw new MustacheException(MustacheProblem.TEMPLATE_MODIFICATION_NOT_ALLOWED, this.toString(), new Object[0]);
        }
    }

    protected MustacheTagType getTagType() {
        return this.getType().getTagType();
    }

    class DefaultSegmentInfo
    implements MustacheTagInfo {
        private final MustacheTagType type;
        private final String text;
        private final int line;
        private final String templateName;

        public DefaultSegmentInfo(MustacheTagType type, String text, int line, String templateName) {
            this.type = type;
            this.text = text;
            this.line = line;
            this.templateName = templateName;
        }

        @Override
        public MustacheTagType getType() {
            return this.type;
        }

        @Override
        public String getText() {
            return this.text;
        }

        @Override
        public int getLine() {
            return this.line;
        }

        @Override
        public String getTemplateName() {
            return this.templateName;
        }
    }
}

