/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.segment;

import org.trimou.annotations.Internal;
import org.trimou.engine.MustacheTagType;
import org.trimou.engine.context.ExecutionContext;
import org.trimou.engine.context.ValueWrapper;
import org.trimou.engine.segment.AbstractSegment;
import org.trimou.engine.segment.HelperAwareSegment;
import org.trimou.engine.segment.HelperExecutionHandler;
import org.trimou.engine.segment.Lambdas;
import org.trimou.engine.segment.Origin;
import org.trimou.engine.segment.SegmentType;
import org.trimou.engine.segment.TemplateSegment;
import org.trimou.lambda.Lambda;

@Internal
public class ValueSegment
extends AbstractSegment
implements HelperAwareSegment {
    private final boolean unescape;
    private final HelperExecutionHandler helperHandler;

    public ValueSegment(String text, Origin origin, boolean unescape) {
        super(text, origin);
        this.unescape = unescape;
        this.helperHandler = this.isHandlebarsSupportEnabled() ? HelperExecutionHandler.from(text, this.getEngine(), this) : null;
    }

    @Override
    public SegmentType getType() {
        return SegmentType.VALUE;
    }

    public boolean isUnescape() {
        return this.unescape;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Appendable appendable, ExecutionContext context) {
        if (this.helperHandler != null) {
            this.helperHandler.execute(appendable, context);
        } else {
            ValueWrapper value = context.getValue(this.getText());
            try {
                if (value.isNull()) {
                    Object replacement = this.getEngineConfiguration().getMissingValueHandler().handle(this.getTagInfo());
                    if (replacement != null) {
                        this.processValue(appendable, context, replacement);
                    }
                } else {
                    this.processValue(appendable, context, value.get());
                }
            }
            finally {
                value.release();
            }
        }
    }

    @Override
    public void fn(Appendable appendable, ExecutionContext context) {
    }

    @Override
    protected String getSegmentName() {
        return this.getText();
    }

    @Override
    protected MustacheTagType getTagType() {
        return this.unescape ? MustacheTagType.UNESCAPE_VARIABLE : MustacheTagType.VARIABLE;
    }

    private void processValue(Appendable appendable, ExecutionContext context, Object value) {
        if (value instanceof Lambda) {
            this.processLambda(appendable, context, value);
        } else {
            this.writeValue(appendable, value.toString());
        }
    }

    private void writeValue(Appendable appendable, String text) {
        this.append(appendable, this.unescape ? text : this.getEngineConfiguration().getTextSupport().escapeHtml(text));
    }

    private void processLambda(Appendable appendable, ExecutionContext context, Object value) {
        Lambda lambda = (Lambda)value;
        String returnValue = lambda.invoke(null);
        if (lambda.isReturnValueInterpolated()) {
            StringBuilder interpolated = new StringBuilder();
            TemplateSegment temp = (TemplateSegment)this.getEngine().compileMustache(Lambdas.constructLambdaOneoffTemplateName(this), returnValue);
            temp.execute(interpolated, context);
            this.writeValue(appendable, interpolated.toString());
        } else {
            this.writeValue(appendable, returnValue);
        }
    }
}

