/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.handlebars;

import org.trimou.engine.MustacheTagType;
import org.trimou.engine.config.AbstractConfigurationAware;
import org.trimou.engine.config.Configuration;
import org.trimou.engine.config.EngineConfigurationKey;
import org.trimou.engine.text.TextSupport;
import org.trimou.handlebars.Helper;
import org.trimou.handlebars.HelperDefinition;
import org.trimou.handlebars.Options;

public abstract class AbstractHelper
extends AbstractConfigurationAware
implements Helper {
    private TextSupport textSupport;

    @Override
    public void validate(HelperDefinition definition) {
    }

    @Override
    public void init(Configuration configuration) {
        super.init(configuration);
        if (!configuration.getBooleanPropertyValue(EngineConfigurationKey.SKIP_VALUE_ESCAPING).booleanValue()) {
            this.textSupport = configuration.getTextSupport();
        }
    }

    protected Object getHashValue(Options options, String key) {
        return options.getHash().isEmpty() ? null : options.getHash().get(key);
    }

    protected boolean isSection(Options options) {
        return options.getTagInfo().getType().equals((Object)MustacheTagType.SECTION);
    }

    protected boolean isVariable(Options options) {
        return options.getTagInfo().getType().equals((Object)MustacheTagType.VARIABLE) || options.getTagInfo().getType().equals((Object)MustacheTagType.UNESCAPE_VARIABLE);
    }

    protected boolean isUnescapeVariable(Options options) {
        return options.getTagInfo().getType().equals((Object)MustacheTagType.UNESCAPE_VARIABLE);
    }

    protected void append(Options options, CharSequence sequence) {
        if (this.isUnescapeVariable(options) || this.textSupport == null) {
            options.append(sequence);
        } else {
            options.append(this.textSupport.escapeHtml(sequence.toString()));
        }
    }
}

