/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.handlebars.i18n;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.trimou.engine.MustacheTagInfo;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;
import org.trimou.handlebars.Options;
import org.trimou.handlebars.i18n.LocaleAwareValueHelper;

public class DateTimeFormatHelper
extends LocaleAwareValueHelper {
    private static final String OPTION_KEY_PATTERN = "pattern";
    private static final String OPTION_KEY_STYLE = "style";

    @Override
    public void execute(Options options) {
        Object formattableObject = this.getFormattableObject(options);
        if (options.getHash().isEmpty()) {
            this.appendStyle(options, formattableObject, 2);
        } else if (options.getHash().containsKey(OPTION_KEY_PATTERN)) {
            this.appendCustom(options, formattableObject);
        } else if (options.getHash().containsKey(OPTION_KEY_STYLE)) {
            this.appendStyle(options, formattableObject);
        }
    }

    private void appendStyle(Options options, Object formattableObject) {
        this.appendStyle(options, formattableObject, this.parseDateFormatStyle(this.getHashValue(options, OPTION_KEY_STYLE).toString(), options.getTagInfo()));
    }

    private void appendStyle(Options options, Object formattableObject, int style) {
        this.append(options, this.format(style, formattableObject));
    }

    private void appendCustom(Options options, Object object) {
        this.append(options, new SimpleDateFormat(options.getHash().get(OPTION_KEY_PATTERN).toString(), this.getCurrentLocale()).format(object));
    }

    private Object getFormattableObject(Options options) {
        Object value = options.getParameters().get(0);
        if (value instanceof Date || value instanceof Number) {
            return value;
        }
        if (value instanceof Calendar) {
            return ((Calendar)value).getTime();
        }
        throw new MustacheException(MustacheProblem.RENDER_HELPER_INVALID_OPTIONS, "Formattable date time object not found [template: %s, line: %s]", options.getTagInfo().getTemplateName(), options.getTagInfo().getLine());
    }

    private String format(int style, Object object) {
        return DateFormat.getDateTimeInstance(style, style, this.getCurrentLocale()).format(object);
    }

    private int parseDateFormatStyle(String style, MustacheTagInfo tagInfo) {
        if ("full".equals(style)) {
            return 0;
        }
        if ("long".equals(style)) {
            return 1;
        }
        if ("short".equals(style)) {
            return 3;
        }
        if ("medium".equals(style)) {
            return 2;
        }
        throw new MustacheException(MustacheProblem.RENDER_HELPER_INVALID_OPTIONS, "Unknown style defined %s [template: %s, line: %s]", style, tagInfo.getTemplateName(), tagInfo.getLine());
    }
}

