/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import org.trimou.annotations.Internal;

@Internal
public final class Checker {
    private Checker() {
    }

    public static void checkArgumentsNotNull(Object ... arguments) {
        for (Object argument : arguments) {
            Checker.checkArgumentNotNull(argument);
        }
    }

    public static void checkArgumentNotNull(Object argument) {
        Preconditions.checkArgument((argument != null ? 1 : 0) != 0, (Object)"Argument must not be null");
    }

    public static void checkArgumentNotEmpty(String argument) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)argument) ? 1 : 0) != 0);
    }

    public static boolean isNullOrEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNullOrEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isFalsy(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof Boolean) {
            return (Boolean)value == false;
        }
        if (value instanceof Collection) {
            return ((Collection)value).isEmpty();
        }
        if (value instanceof Iterable) {
            return !((Iterable)value).iterator().hasNext();
        }
        if (value.getClass().isArray()) {
            return Array.getLength(value) == 0;
        }
        if (value instanceof CharSequence) {
            return ((CharSequence)value).length() == 0;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() == 0;
        }
        return false;
    }
}

