/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine;

import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.io.CharStreams;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trimou.Mustache;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.engine.config.Configuration;
import org.trimou.engine.config.ConfigurationFactory;
import org.trimou.engine.config.EngineConfigurationKey;
import org.trimou.engine.listener.MustacheCompilationEvent;
import org.trimou.engine.listener.MustacheListener;
import org.trimou.engine.listener.MustacheParsingEvent;
import org.trimou.engine.locator.TemplateLocator;
import org.trimou.engine.parser.ParserFactory;
import org.trimou.engine.parser.ParsingHandler;
import org.trimou.engine.parser.ParsingHandlerFactory;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;
import org.trimou.util.Checker;

class DefaultMustacheEngine
implements MustacheEngine {
    private static final Logger logger = LoggerFactory.getLogger(DefaultMustacheEngine.class);
    private final LoadingCache<String, Optional<Mustache>> templateCache;
    private final LoadingCache<String, Optional<String>> sourceCache;
    private final Configuration configuration;
    private final ParserFactory parserFactory;
    private final ParsingHandlerFactory parsingHandlerFactory;

    DefaultMustacheEngine() {
        this.configuration = null;
        this.parserFactory = null;
        this.parsingHandlerFactory = null;
        this.templateCache = null;
        this.sourceCache = null;
    }

    DefaultMustacheEngine(MustacheEngineBuilder builder) {
        this.configuration = new ConfigurationFactory().createConfiguration(builder);
        this.parserFactory = new ParserFactory();
        this.parsingHandlerFactory = new ParsingHandlerFactory();
        if (this.configuration.getBooleanPropertyValue(EngineConfigurationKey.DEBUG_MODE).booleanValue()) {
            this.templateCache = null;
            this.sourceCache = null;
            logger.warn("Attention! Debug mode enabled: template cache disabled, additional logging enabled");
        } else if (this.configuration.getBooleanPropertyValue(EngineConfigurationKey.TEMPLATE_CACHE_ENABLED).booleanValue()) {
            this.templateCache = this.buildTemplateCache();
            this.sourceCache = this.buildSourceCache();
            if (this.configuration.getBooleanPropertyValue(EngineConfigurationKey.PRECOMPILE_ALL_TEMPLATES).booleanValue()) {
                this.precompileTemplates();
            }
        } else {
            this.templateCache = null;
            this.sourceCache = null;
            logger.info("Template cache explicitly disabled!");
        }
    }

    @Override
    public Mustache getMustache(String templateId) {
        Checker.checkArgumentNotEmpty(templateId);
        return this.templateCache != null ? this.getTemplateFromCache(templateId) : this.locateAndParse(templateId);
    }

    @Override
    public String getMustacheSource(String templateId) {
        Checker.checkArgumentNotEmpty(templateId);
        return this.sourceCache != null ? this.getSourceFromCache(templateId) : this.locateAndRead(templateId);
    }

    @Override
    public Mustache compileMustache(String templateId, String templateContent) {
        Checker.checkArgumentNotEmpty(templateId);
        Checker.checkArgumentNotEmpty(templateContent);
        return this.parse(templateId, new StringReader(templateContent));
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void invalidateTemplateCache() {
        if (this.templateCache == null) {
            logger.warn("Unable to invalidate the template cache - it's disabled!");
            return;
        }
        this.templateCache.invalidateAll();
        this.sourceCache.invalidateAll();
    }

    private LoadingCache<String, Optional<Mustache>> buildTemplateCache() {
        return this.buildCache("Template", new CacheLoader<String, Optional<Mustache>>(){

            public Optional<Mustache> load(String key) throws Exception {
                return Optional.fromNullable((Object)DefaultMustacheEngine.this.locateAndParse(key));
            }
        }, new RemovalListener<String, Optional<Mustache>>(){

            public void onRemoval(RemovalNotification<String, Optional<Mustache>> notification) {
                logger.debug("Removed template from cache [templateId: {}, cause: {}]", notification.getKey(), (Object)notification.getCause());
            }
        });
    }

    private LoadingCache<String, Optional<String>> buildSourceCache() {
        return this.buildCache("Source", new CacheLoader<String, Optional<String>>(){

            public Optional<String> load(String key) throws Exception {
                return Optional.fromNullable((Object)DefaultMustacheEngine.this.locateAndRead(key));
            }
        }, new RemovalListener<String, Optional<String>>(){

            public void onRemoval(RemovalNotification<String, Optional<String>> notification) {
                logger.debug("Removed template source from cache [templateId: {}, cause: {}]", notification.getKey(), (Object)notification.getCause());
            }
        });
    }

    private <K, V> LoadingCache<K, V> buildCache(String name, CacheLoader<K, V> cacheLoader, RemovalListener<K, V> removalListener) {
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder();
        long expirationTimeout = this.configuration.getLongPropertyValue(EngineConfigurationKey.TEMPLATE_CACHE_EXPIRATION_TIMEOUT);
        if (expirationTimeout > 0L) {
            logger.info("{} cache expiration timeout set: {} seconds", (Object)name, (Object)expirationTimeout);
            cacheBuilder.expireAfterWrite(expirationTimeout, TimeUnit.SECONDS);
            cacheBuilder.removalListener(removalListener);
        }
        return cacheBuilder.build(cacheLoader);
    }

    private void precompileTemplates() {
        HashSet<String> templateNames = new HashSet<String>();
        for (TemplateLocator locator : this.configuration.getTemplateLocators()) {
            templateNames.addAll(locator.getAllIdentifiers());
        }
        for (String templateName : templateNames) {
            this.getTemplateFromCache(templateName);
        }
    }

    private Mustache parse(String templateId, Reader reader) {
        ParsingHandler handler = this.parsingHandlerFactory.createParsingHandler();
        reader = this.notifyListenersBeforeParsing(templateId, reader);
        this.parserFactory.createParser(this).parse(templateId, reader, handler);
        Mustache mustache = handler.getCompiledTemplate();
        this.notifyListenersAfterCompilation(mustache);
        return mustache;
    }

    private Reader locate(String templateId) {
        TemplateLocator locator;
        if (this.configuration.getTemplateLocators() == null || this.configuration.getTemplateLocators().isEmpty()) {
            return null;
        }
        Reader reader = null;
        Iterator<TemplateLocator> i$ = this.configuration.getTemplateLocators().iterator();
        while (i$.hasNext() && (reader = (locator = i$.next()).locate(templateId)) == null) {
        }
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Mustache locateAndParse(String templateId) {
        Reader reader = null;
        try {
            reader = this.locate(templateId);
            if (reader == null) {
                Mustache mustache = null;
                return mustache;
            }
            Mustache mustache = this.parse(templateId, reader);
            return mustache;
        }
        finally {
            this.closeReader(reader, templateId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String locateAndRead(String templateId) {
        Reader reader = null;
        try {
            reader = this.locate(templateId);
            if (reader == null) {
                String string = null;
                return string;
            }
            String string = CharStreams.toString((Readable)reader);
            return string;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            this.closeReader(reader, templateId);
        }
    }

    private void closeReader(Reader reader, String templateId) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException e) {
                logger.warn("Unable to close the reader for " + templateId, (Throwable)e);
            }
        }
    }

    private Reader notifyListenersBeforeParsing(String templateName, Reader reader) {
        if (this.configuration.getMustacheListeners() != null) {
            DefaultMustacheParsingEvent event = new DefaultMustacheParsingEvent(templateName, reader);
            for (MustacheListener listener : this.configuration.getMustacheListeners()) {
                listener.parsingStarted(event);
            }
            return event.getMustacheContents();
        }
        return reader;
    }

    private void notifyListenersAfterCompilation(Mustache mustache) {
        if (this.configuration.getMustacheListeners() != null) {
            DefaultMustacheCompilationEvent event = new DefaultMustacheCompilationEvent(mustache);
            for (MustacheListener listener : this.configuration.getMustacheListeners()) {
                listener.compilationFinished(event);
            }
        }
    }

    private Mustache getTemplateFromCache(String templateName) {
        try {
            return (Mustache)((Optional)this.templateCache.get((Object)templateName)).orNull();
        }
        catch (ExecutionException e) {
            throw new MustacheException(MustacheProblem.TEMPLATE_LOADING_ERROR, e.getCause());
        }
        catch (UncheckedExecutionException e) {
            throw this.unwrapUncheckedExecutionException((Exception)((Object)e));
        }
    }

    private String getSourceFromCache(String templateName) {
        try {
            return (String)((Optional)this.sourceCache.get((Object)templateName)).orNull();
        }
        catch (ExecutionException e) {
            throw new MustacheException(MustacheProblem.TEMPLATE_LOADING_ERROR, e.getCause());
        }
        catch (UncheckedExecutionException e) {
            throw this.unwrapUncheckedExecutionException((Exception)((Object)e));
        }
    }

    private RuntimeException unwrapUncheckedExecutionException(Exception e) {
        if (e.getCause() instanceof RuntimeException) {
            return (RuntimeException)e.getCause();
        }
        return new MustacheException(MustacheProblem.TEMPLATE_LOADING_ERROR, e.getCause());
    }

    private static class DefaultMustacheParsingEvent
    implements MustacheParsingEvent {
        private final String mustacheName;
        private Reader reader;

        public DefaultMustacheParsingEvent(String mustacheName, Reader reader) {
            this.mustacheName = mustacheName;
            this.reader = reader;
        }

        @Override
        public String getMustacheName() {
            return this.mustacheName;
        }

        @Override
        public Reader getMustacheContents() {
            return this.reader;
        }

        @Override
        public void setMustacheContents(Reader reader) {
            this.reader = reader;
        }
    }

    private static class DefaultMustacheCompilationEvent
    implements MustacheCompilationEvent {
        private final Mustache mustache;

        public DefaultMustacheCompilationEvent(Mustache mustache) {
            this.mustache = mustache;
        }

        @Override
        public Mustache getMustache() {
            return this.mustache;
        }
    }
}

