/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trimou.engine.DefaultMustacheEngine;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.config.ConfigurationExtension;
import org.trimou.engine.config.ConfigurationKey;
import org.trimou.engine.interpolation.KeySplitter;
import org.trimou.engine.interpolation.MissingValueHandler;
import org.trimou.engine.listener.MustacheListener;
import org.trimou.engine.locale.LocaleSupport;
import org.trimou.engine.locator.TemplateLocator;
import org.trimou.engine.resolver.Resolver;
import org.trimou.engine.text.TextSupport;
import org.trimou.handlebars.Helper;
import org.trimou.util.Checker;

public final class MustacheEngineBuilder
implements ConfigurationExtension.ConfigurationExtensionBuilder {
    private static final Logger logger = LoggerFactory.getLogger(MustacheEngineBuilder.class);
    private boolean omitServiceLoaderConfigurationExtensions = false;
    private boolean isMutable = true;
    private final ImmutableSet.Builder<Resolver> resolversBuilder = ImmutableSet.builder();
    private final ImmutableSet.Builder<TemplateLocator> templateLocators = ImmutableSet.builder();
    private final ImmutableMap.Builder<String, Object> globalData = ImmutableMap.builder();
    private TextSupport textSupport;
    private LocaleSupport localeSupport;
    private final ImmutableMap.Builder<String, Object> properties = ImmutableMap.builder();
    private final List<EngineBuiltCallback> engineReadyCallbacks;
    private final ImmutableList.Builder<MustacheListener> mustacheListeners = ImmutableList.builder();
    private KeySplitter keySplitter;
    private MissingValueHandler missingValueHandler;
    private final ImmutableMap.Builder<String, Helper> helpers = ImmutableMap.builder();

    private MustacheEngineBuilder() {
        this.engineReadyCallbacks = new ArrayList<EngineBuiltCallback>();
    }

    public MustacheEngine build() {
        this.checkIsMutable("build()");
        DefaultMustacheEngine engine = new DefaultMustacheEngine(this);
        for (EngineBuiltCallback callback : this.engineReadyCallbacks) {
            callback.engineBuilt(engine);
        }
        Package pack = MustacheEngine.class.getPackage();
        logger.info("Engine built {}{}", (Object)(StringUtils.isEmpty((CharSequence)pack.getSpecificationVersion()) ? "SNAPSHOT" : pack.getSpecificationVersion()), (Object)engine.getConfiguration().getInfo());
        this.isMutable = false;
        return engine;
    }

    @Override
    public MustacheEngineBuilder addGlobalData(String name, Object value) {
        Checker.checkArgumentsNotNull(name, value);
        this.checkIsMutable("addGlobalData()");
        this.globalData.put((Object)name, value);
        return this;
    }

    public MustacheEngineBuilder addTemplateLocator(TemplateLocator locator) {
        Checker.checkArgumentNotNull(locator);
        this.checkIsMutable("addTemplateLocator()");
        this.templateLocators.add((Object)locator);
        return this;
    }

    @Override
    public MustacheEngineBuilder addResolver(Resolver resolver) {
        Checker.checkArgumentNotNull(resolver);
        this.checkIsMutable("addResolver()");
        this.resolversBuilder.add((Object)resolver);
        return this;
    }

    public MustacheEngineBuilder setProperty(String key, Object value) {
        Checker.checkArgumentsNotNull(key, value);
        this.checkIsMutable("setProperty()");
        this.properties.put((Object)key, value);
        return this;
    }

    public <T extends ConfigurationKey> MustacheEngineBuilder setProperty(T configurationKey, Object value) {
        Checker.checkArgumentsNotNull(configurationKey, value);
        this.checkIsMutable("setProperty()");
        this.setProperty(configurationKey.get(), value);
        return this;
    }

    public MustacheEngineBuilder setTextSupport(TextSupport textSupport) {
        Checker.checkArgumentNotNull(textSupport);
        this.checkIsMutable("setTextSupport()");
        this.textSupport = textSupport;
        return this;
    }

    public MustacheEngineBuilder setLocaleSupport(LocaleSupport localeSupport) {
        Checker.checkArgumentNotNull(localeSupport);
        this.checkIsMutable("setLocaleSupport()");
        this.localeSupport = localeSupport;
        return this;
    }

    public MustacheEngineBuilder registerCallback(EngineBuiltCallback callback) {
        Checker.checkArgumentNotNull(callback);
        this.checkIsMutable("registerCallback()");
        this.engineReadyCallbacks.add(callback);
        return this;
    }

    @Override
    public MustacheEngineBuilder addMustacheListener(MustacheListener listener) {
        Checker.checkArgumentNotNull(listener);
        this.checkIsMutable("addMustacheListener()");
        this.mustacheListeners.add((Object)listener);
        return this;
    }

    public MustacheEngineBuilder setKeySplitter(KeySplitter keySplitter) {
        Checker.checkArgumentNotNull(keySplitter);
        this.checkIsMutable("setKeySplitter()");
        this.keySplitter = keySplitter;
        return this;
    }

    public MustacheEngineBuilder setMissingValueHandler(MissingValueHandler missingValueHandler) {
        Checker.checkArgumentNotNull(missingValueHandler);
        this.checkIsMutable("setMissingValueHandler()");
        this.missingValueHandler = missingValueHandler;
        return this;
    }

    @Override
    public MustacheEngineBuilder registerHelper(String name, Helper helper) {
        Checker.checkArgumentsNotNull(name, helper);
        this.checkIsMutable("registerHelper()");
        this.helpers.put((Object)name, (Object)helper);
        return this;
    }

    @Override
    public MustacheEngineBuilder registerHelpers(Map<String, Helper> helpers) {
        if (Checker.isNullOrEmpty(helpers)) {
            return this;
        }
        this.checkIsMutable("registerHelpers()");
        this.helpers.putAll(helpers);
        return this;
    }

    public MustacheEngineBuilder omitServiceLoaderConfigurationExtensions() {
        this.checkIsMutable("omitServiceLoaderConfigurationExtensions()");
        this.omitServiceLoaderConfigurationExtensions = true;
        return this;
    }

    public static MustacheEngineBuilder newBuilder() {
        return new MustacheEngineBuilder();
    }

    public Set<TemplateLocator> buildTemplateLocators() {
        return this.templateLocators.build();
    }

    public Set<Resolver> buildResolvers() {
        return this.resolversBuilder.build();
    }

    public Map<String, Object> buildGlobalData() {
        return this.globalData.build();
    }

    public TextSupport getTextSupport() {
        return this.textSupport;
    }

    public LocaleSupport getLocaleSupport() {
        return this.localeSupport;
    }

    public boolean isOmitServiceLoaderConfigurationExtensions() {
        return this.omitServiceLoaderConfigurationExtensions;
    }

    public Map<String, Object> buildProperties() {
        return this.properties.build();
    }

    public List<MustacheListener> buildMustacheListeners() {
        return this.mustacheListeners.build();
    }

    public KeySplitter getKeySplitter() {
        return this.keySplitter;
    }

    public MissingValueHandler getMissingValueHandler() {
        return this.missingValueHandler;
    }

    public Map<String, Helper> buildHelpers() {
        return this.helpers.build();
    }

    private void checkIsMutable(String methodName) {
        if (!this.isMutable) {
            throw new IllegalStateException("Invalid method invocation - builder already built: " + methodName);
        }
    }

    public static interface EngineBuiltCallback {
        public void engineBuilt(MustacheEngine var1);
    }
}

