/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.config;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.trimou.annotations.Internal;

@Internal
public final class ConfigurationProperties {
    private ConfigurationProperties() {
    }

    public static String buildPropertyKey(String propertyName, String[] prefixParts) {
        return ConfigurationProperties.buildPropertyKey(propertyName, "_", prefixParts);
    }

    public static String buildPropertyKey(String propertyName, String delimiter, String[] prefixParts) {
        StringBuilder key = new StringBuilder();
        for (int i = 0; i < prefixParts.length; ++i) {
            key.append(prefixParts[i]);
            key.append(".");
        }
        key.append(WordUtils.uncapitalize((String)StringUtils.replace((String)WordUtils.capitalizeFully((String)propertyName, (char[])delimiter.toCharArray()), (String)delimiter, (String)"")));
        return key.toString();
    }

    public static Object convertConfigValue(Class<?> defaultValueType, Object value) {
        if (defaultValueType.equals(String.class)) {
            return value.toString();
        }
        if (defaultValueType.equals(Boolean.class)) {
            return Boolean.valueOf(value.toString());
        }
        if (defaultValueType.equals(Long.class)) {
            return Long.valueOf(value.toString());
        }
        if (defaultValueType.equals(Integer.class)) {
            return Integer.valueOf(value.toString());
        }
        throw new IllegalStateException("Unsupported default value type: " + defaultValueType);
    }
}

