/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.listener;

import com.google.common.base.Predicate;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.trimou.engine.listener.AbstractMustacheListener;
import org.trimou.engine.listener.MustacheRenderingEvent;
import org.trimou.engine.resource.ReleaseCallback;
import org.trimou.util.Checker;

public class SimpleStatsCollector
extends AbstractMustacheListener {
    public static final Predicate<String> IS_NOT_ONEOFF_LAMBA_TEMPLATE = new Predicate<String>(){

        public boolean apply(String input) {
            return !input.startsWith("oneoff_lambda_");
        }
    };
    protected final TimeUnit timeUnit;
    protected final Predicate<String> templatePredicate;
    protected final LoadingCache<String, LoadingCache<Long, AtomicLong>> data;

    public SimpleStatsCollector() {
        this(IS_NOT_ONEOFF_LAMBA_TEMPLATE, TimeUnit.MILLISECONDS);
    }

    public SimpleStatsCollector(Predicate<String> templatePredicate, TimeUnit timeUnit) {
        Checker.checkArgumentsNotNull(new Object[]{templatePredicate, timeUnit});
        this.timeUnit = timeUnit;
        this.templatePredicate = templatePredicate;
        this.data = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, LoadingCache<Long, AtomicLong>>(){

            public LoadingCache<Long, AtomicLong> load(String key) throws Exception {
                return CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Long, AtomicLong>(){

                    public AtomicLong load(Long key) throws Exception {
                        return new AtomicLong(0L);
                    }
                });
            }
        });
    }

    @Override
    public void renderingStarted(final MustacheRenderingEvent event) {
        if (this.templatePredicate.apply((Object)event.getMustacheName())) {
            final long start = System.nanoTime();
            event.registerReleaseCallback(new ReleaseCallback(){

                @Override
                public void release() {
                    ((AtomicLong)((LoadingCache)SimpleStatsCollector.this.data.getUnchecked((Object)event.getMustacheName())).getUnchecked((Object)SimpleStatsCollector.this.timeUnit.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS))).incrementAndGet();
                }
            });
        }
    }

    public void clearData() {
        this.data.invalidateAll();
        this.data.cleanUp();
    }

    public Map<Long, Long> getData(String templateId) {
        LoadingCache templateData = (LoadingCache)this.data.getIfPresent((Object)templateId);
        if (templateData != null) {
            return this.getImmutableTemplateData((LoadingCache<Long, AtomicLong>)templateData);
        }
        return null;
    }

    public Map<String, Map<Long, Long>> getData() {
        if (this.data.size() == 0L) {
            return Collections.emptyMap();
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : this.data.asMap().entrySet()) {
            builder.put(entry.getKey(), this.getImmutableTemplateData((LoadingCache<Long, AtomicLong>)((LoadingCache)entry.getValue())));
        }
        return builder.build();
    }

    public SimpleStats getSimpleStats(String templateId) {
        LoadingCache entry = (LoadingCache)this.data.getIfPresent((Object)templateId);
        if (entry != null) {
            return new SimpleStats(templateId, entry.asMap());
        }
        return null;
    }

    public Set<SimpleStats> getSimpleStats() {
        if (this.data.size() == 0L) {
            return Collections.emptySet();
        }
        ImmutableSet.Builder buidler = ImmutableSet.builder();
        for (Map.Entry entry : this.data.asMap().entrySet()) {
            buidler.add((Object)new SimpleStats((String)entry.getKey(), ((LoadingCache)entry.getValue()).asMap()));
        }
        return buidler.build();
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    private Map<Long, Long> getImmutableTemplateData(LoadingCache<Long, AtomicLong> templateData) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : templateData.asMap().entrySet()) {
            builder.put(entry.getKey(), (Object)((AtomicLong)entry.getValue()).get());
        }
        return builder.build();
    }

    public class SimpleStats {
        private final String name;
        private final long executions;
        private final long totalTime;
        private final long meanTime;
        private final long minTime;
        private final long maxTime;

        SimpleStats(String name, Map<Long, AtomicLong> data) {
            this.name = name;
            long executions = 0L;
            long totalTime = 0L;
            for (Map.Entry<Long, AtomicLong> entry : data.entrySet()) {
                executions += entry.getValue().get();
                totalTime += entry.getKey() * entry.getValue().get();
            }
            this.executions = executions;
            this.totalTime = totalTime;
            this.meanTime = totalTime / executions;
            this.minTime = Collections.min(data.keySet());
            this.maxTime = Collections.max(data.keySet());
        }

        public String getName() {
            return this.name;
        }

        public long getExecutions() {
            return this.executions;
        }

        public long getTotalTime() {
            return this.totalTime;
        }

        public long getMeanTime() {
            return this.meanTime;
        }

        public long getMinTime() {
            return this.minTime;
        }

        public long getMaxTime() {
            return this.maxTime;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SimpleStats other = (SimpleStats)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public String toString() {
            return String.format("SimpleStats [name: %s, executions: %s, totalTime: %s, meanTime: %s, minTime: %s, maxTime: %s, timeUnit: %s]", new Object[]{this.name, this.executions, this.totalTime, this.meanTime, this.minTime, this.maxTime, SimpleStatsCollector.this.timeUnit});
        }
    }
}

