/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.locator;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trimou.engine.locator.FilePathTemplateLocator;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;
import org.trimou.util.Checker;

public class ClassPathTemplateLocator
extends FilePathTemplateLocator {
    private static final Logger logger = LoggerFactory.getLogger(ClassPathTemplateLocator.class);
    private final ClassLoader classLoader;

    public ClassPathTemplateLocator(int priority, String rootPath) {
        this(priority, rootPath, Thread.currentThread().getContextClassLoader());
    }

    public ClassPathTemplateLocator(int priority, String rootPath, String suffix) {
        this(priority, rootPath, suffix, Thread.currentThread().getContextClassLoader());
    }

    public ClassPathTemplateLocator(int priority, String rootPath, ClassLoader classLoader) {
        this(priority, rootPath, null, classLoader);
    }

    public ClassPathTemplateLocator(int priority, String rootPath, String suffix, ClassLoader classLoader) {
        super(priority, rootPath, suffix);
        Checker.checkArgumentNotNull(classLoader);
        this.classLoader = classLoader;
        this.checkRootDir();
    }

    @Override
    public Set<String> getAllIdentifiers() {
        if (this.getRootPath() == null) {
            return Collections.emptySet();
        }
        return super.getAllIdentifiers();
    }

    @Override
    public Reader locateRealPath(String realPath) {
        String name = this.getRootPath() != null ? this.getRootPath() + this.addSuffix(realPath) : this.addSuffix(realPath);
        InputStream in = this.classLoader.getResourceAsStream(name);
        if (in == null) {
            return null;
        }
        logger.debug("Template located: {}", (Object)(this.getRootPath() + realPath));
        try {
            return new InputStreamReader(in, this.getDefaultFileEncoding());
        }
        catch (UnsupportedEncodingException e) {
            throw new MustacheException(MustacheProblem.TEMPLATE_LOADING_ERROR, (Throwable)e);
        }
    }

    @Override
    protected File getRootDir() {
        if (this.getRootPath() == null) {
            return null;
        }
        try {
            URL url = this.classLoader.getResource(this.getRootPath());
            if (url == null) {
                throw new MustacheException(MustacheProblem.TEMPLATE_LOCATOR_INVALID_CONFIGURATION, "Root path resource not found: %s", this.getRootPath());
            }
            return new File(URLDecoder.decode(url.getFile(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new MustacheException(MustacheProblem.TEMPLATE_LOCATOR_INVALID_CONFIGURATION, (Throwable)e);
        }
    }

    public static Builder builder(int priority) {
        return new Builder(priority);
    }

    public static class Builder {
        private ClassLoader classLoader;
        private int priority;
        private String rootPath;
        private String suffix;

        private Builder(int priority) {
            this.priority = priority;
        }

        public Builder setClassLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
            return this;
        }

        public Builder setRootPath(String rootPath) {
            this.rootPath = rootPath;
            return this;
        }

        public Builder setSuffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        public ClassPathTemplateLocator build() {
            return this.classLoader != null ? new ClassPathTemplateLocator(this.priority, this.rootPath, this.suffix, this.classLoader) : new ClassPathTemplateLocator(this.priority, this.rootPath, this.suffix);
        }
    }
}

