/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trimou.engine.parser.DefaultParsingHandler;
import org.trimou.engine.segment.SegmentType;

final class SegmentBases {
    private static final Logger logger = LoggerFactory.getLogger(SegmentBases.class);

    private SegmentBases() {
    }

    static void removeStandaloneLines(DefaultParsingHandler.RootSegmentBase rootSegment) {
        List<List<DefaultParsingHandler.SegmentBase>> lines = SegmentBases.readSegmentLines(rootSegment);
        HashSet<DefaultParsingHandler.SegmentBase> segmentsToRemove = new HashSet<DefaultParsingHandler.SegmentBase>();
        int idx = 0;
        for (List<DefaultParsingHandler.SegmentBase> line : lines) {
            ++idx;
            if (!SegmentBases.isStandaloneLine(line)) continue;
            SegmentBases.extractIndentationForPartial(line);
            for (DefaultParsingHandler.SegmentBase segment : line) {
                if (segment instanceof DefaultParsingHandler.ContainerSegmentBase || SegmentType.PARTIAL.equals((Object)segment.getType())) continue;
                segmentsToRemove.add(segment);
            }
            logger.trace("Segment line {} is standalone", (Object)idx);
        }
        if (!segmentsToRemove.isEmpty()) {
            SegmentBases.removeSegments(segmentsToRemove, rootSegment);
            logger.debug("{} segments removed", (Object)segmentsToRemove.size());
        }
    }

    static void removeUnnecessarySegments(DefaultParsingHandler.ContainerSegmentBase container) {
        Iterator<DefaultParsingHandler.SegmentBase> iterator = container.iterator();
        while (iterator.hasNext()) {
            DefaultParsingHandler.SegmentBase segment = iterator.next();
            if (segment instanceof DefaultParsingHandler.ContainerSegmentBase) {
                SegmentBases.removeUnnecessarySegments((DefaultParsingHandler.ContainerSegmentBase)segment);
                continue;
            }
            if (!SegmentType.COMMENT.equals((Object)segment.getType()) && !SegmentType.DELIMITERS.equals((Object)segment.getType())) continue;
            iterator.remove();
        }
    }

    static void reuseLineSeparatorSegments(DefaultParsingHandler.ContainerSegmentBase container) {
        HashMap<String, DefaultParsingHandler.SegmentBase> lineSeparators = new HashMap<String, DefaultParsingHandler.SegmentBase>();
        ListIterator<DefaultParsingHandler.SegmentBase> iterator = container.listIterator();
        while (iterator.hasNext()) {
            DefaultParsingHandler.SegmentBase segment = iterator.next();
            if (segment instanceof DefaultParsingHandler.ContainerSegmentBase) {
                SegmentBases.reuseLineSeparatorSegments((DefaultParsingHandler.ContainerSegmentBase)segment);
                continue;
            }
            if (!SegmentType.LINE_SEPARATOR.equals((Object)segment.getType())) continue;
            DefaultParsingHandler.SegmentBase lineSeparator = (DefaultParsingHandler.SegmentBase)lineSeparators.get(segment.getContent());
            if (lineSeparator == null) {
                lineSeparators.put(segment.getContent(), segment);
                continue;
            }
            iterator.set(lineSeparator);
        }
    }

    static int getNumberOfSegments(DefaultParsingHandler.ContainerSegmentBase container) {
        int count = 0;
        for (DefaultParsingHandler.SegmentBase segmentBase : container) {
            if (segmentBase instanceof DefaultParsingHandler.ContainerSegmentBase) {
                count += SegmentBases.getNumberOfSegments((DefaultParsingHandler.ContainerSegmentBase)segmentBase);
                continue;
            }
            ++count;
        }
        return count;
    }

    private static void extractIndentationForPartial(List<DefaultParsingHandler.SegmentBase> standaloneLine) {
        if (SegmentType.TEXT.equals((Object)standaloneLine.get(0).getType())) {
            DefaultParsingHandler.PartialSegmentBase partial = null;
            for (DefaultParsingHandler.SegmentBase segment : standaloneLine) {
                if (!SegmentType.PARTIAL.equals((Object)segment.getType())) continue;
                partial = (DefaultParsingHandler.PartialSegmentBase)segment;
                break;
            }
            if (partial != null) {
                partial.setIndentation(standaloneLine.get(0).getContent());
            }
        }
    }

    private static void removeSegments(Set<DefaultParsingHandler.SegmentBase> segmentsToRemove, DefaultParsingHandler.ContainerSegmentBase container) {
        Iterator<DefaultParsingHandler.SegmentBase> iterator = container.iterator();
        while (iterator.hasNext()) {
            DefaultParsingHandler.SegmentBase segment = iterator.next();
            if (segment instanceof DefaultParsingHandler.ContainerSegmentBase) {
                SegmentBases.removeSegments(segmentsToRemove, (DefaultParsingHandler.ContainerSegmentBase)segment);
                continue;
            }
            if (!segmentsToRemove.contains(segment)) continue;
            iterator.remove();
        }
    }

    static boolean isStandaloneLine(List<DefaultParsingHandler.SegmentBase> line) {
        boolean standaloneCandidate = false;
        for (DefaultParsingHandler.SegmentBase segment : line) {
            if (SegmentType.VALUE.equals((Object)segment.getType())) {
                return false;
            }
            if (SegmentType.TEXT.equals((Object)segment.getType())) {
                if (StringUtils.isWhitespace((CharSequence)segment.getContent())) continue;
                return false;
            }
            if (!SegmentBases.isStandaloneCandidate(segment.getType())) continue;
            standaloneCandidate = true;
        }
        return standaloneCandidate;
    }

    private static boolean isStandaloneCandidate(SegmentType type) {
        return type.equals((Object)SegmentType.COMMENT) || type.equals((Object)SegmentType.SECTION) || type.equals((Object)SegmentType.INVERTED_SECTION) || type.equals((Object)SegmentType.DELIMITERS) || type.equals((Object)SegmentType.PARTIAL);
    }

    private static List<List<DefaultParsingHandler.SegmentBase>> readSegmentLines(DefaultParsingHandler.ContainerSegmentBase container) {
        ArrayList<List<DefaultParsingHandler.SegmentBase>> lines = new ArrayList<List<DefaultParsingHandler.SegmentBase>>();
        lines.add(SegmentBases.readSegmentLines(lines, null, container));
        return lines;
    }

    private static List<DefaultParsingHandler.SegmentBase> readSegmentLines(List<List<DefaultParsingHandler.SegmentBase>> lines, List<DefaultParsingHandler.SegmentBase> currentLine, DefaultParsingHandler.ContainerSegmentBase container) {
        if (currentLine == null) {
            currentLine = new ArrayList<DefaultParsingHandler.SegmentBase>();
        }
        if (!SegmentType.ROOT.equals((Object)container.getType())) {
            currentLine.add(container);
        }
        for (DefaultParsingHandler.SegmentBase segment : container) {
            if (segment instanceof DefaultParsingHandler.ContainerSegmentBase) {
                currentLine = SegmentBases.readSegmentLines(lines, currentLine, (DefaultParsingHandler.ContainerSegmentBase)segment);
                continue;
            }
            if (!SegmentType.LINE_SEPARATOR.equals((Object)segment.getType())) {
                currentLine.add(segment);
                continue;
            }
            currentLine.add(segment);
            lines.add(currentLine);
            currentLine = new ArrayList<DefaultParsingHandler.SegmentBase>();
        }
        if (!SegmentType.ROOT.equals((Object)container.getType())) {
            currentLine.add(container);
        }
        return currentLine;
    }
}

