/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.resolver;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trimou.engine.config.Configuration;
import org.trimou.engine.config.ConfigurationKey;
import org.trimou.engine.config.SimpleConfigurationKey;
import org.trimou.engine.priority.Priorities;
import org.trimou.engine.resolver.AbstractResolver;
import org.trimou.engine.resolver.FieldWrapper;
import org.trimou.engine.resolver.MemberKey;
import org.trimou.engine.resolver.MemberWrapper;
import org.trimou.engine.resolver.MethodWrapper;
import org.trimou.engine.resolver.ResolutionContext;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;
import org.trimou.util.Reflections;

public class ReflectionResolver
extends AbstractResolver
implements RemovalListener<MemberKey, Optional<MemberWrapper>> {
    private static final Logger logger = LoggerFactory.getLogger(ReflectionResolver.class);
    public static final int REFLECTION_RESOLVER_PRIORITY = Priorities.rightBefore(10);
    public static final ConfigurationKey MEMBER_CACHE_MAX_SIZE_KEY = new SimpleConfigurationKey(ReflectionResolver.class.getName() + ".memberCacheMaxSize", 5000L);
    private LoadingCache<MemberKey, Optional<MemberWrapper>> memberCache;

    public ReflectionResolver() {
        this(REFLECTION_RESOLVER_PRIORITY);
    }

    public ReflectionResolver(int priority) {
        super(priority);
    }

    @Override
    public Object resolve(Object contextObject, String name, ResolutionContext context) {
        if (contextObject == null) {
            return null;
        }
        MemberWrapper wrapper = (MemberWrapper)((Optional)this.memberCache.getUnchecked((Object)MemberKey.newInstance(contextObject, name))).orNull();
        if (wrapper == null) {
            return null;
        }
        try {
            return wrapper.getValue(contextObject);
        }
        catch (Exception e) {
            throw new MustacheException(MustacheProblem.RENDER_REFLECT_INVOCATION_ERROR, (Throwable)e);
        }
    }

    @Override
    public void init(Configuration configuration) {
        this.checkNotInitialized(this.memberCache != null);
        long memberCacheMaxSize = configuration.getLongPropertyValue(MEMBER_CACHE_MAX_SIZE_KEY);
        logger.info("Initialized [memberCacheMaxSize: {}]", (Object)memberCacheMaxSize);
        this.memberCache = CacheBuilder.newBuilder().maximumSize(memberCacheMaxSize).removalListener((RemovalListener)this).build((CacheLoader)new CacheLoader<MemberKey, Optional<MemberWrapper>>(){

            public Optional<MemberWrapper> load(MemberKey key) throws Exception {
                Method foundMethod = Reflections.findMethod(key.getClazz(), key.getName());
                if (foundMethod != null) {
                    return Optional.of((Object)new MethodWrapper(foundMethod));
                }
                Field foundField = Reflections.findField(key.getClazz(), key.getName());
                if (foundField != null) {
                    return Optional.of((Object)new FieldWrapper(foundField));
                }
                return Optional.absent();
            }
        });
    }

    @Override
    public Set<ConfigurationKey> getConfigurationKeys() {
        return Collections.singleton(MEMBER_CACHE_MAX_SIZE_KEY);
    }

    public void onRemoval(RemovalNotification<MemberKey, Optional<MemberWrapper>> notification) {
        logger.debug("Removed member [type: {}, key: {}, cause: {}, memberCacheSize: {}]", new Object[]{((MemberKey)notification.getKey()).getClazz(), ((MemberKey)notification.getKey()).getName(), notification.getCause(), this.memberCache.size()});
    }

    public void invalidateMemberCache(Predicate<Class<?>> predicate) {
        if (predicate == null) {
            this.memberCache.invalidateAll();
        } else {
            ArrayList<MemberKey> keys = new ArrayList<MemberKey>();
            for (MemberKey key : this.memberCache.asMap().keySet()) {
                if (!predicate.apply(key.getClazz())) continue;
                keys.add(key);
            }
            this.memberCache.invalidateAll(keys);
        }
    }
}

