/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.segment;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.MustacheTagInfo;
import org.trimou.engine.context.ExecutionContext;
import org.trimou.engine.context.ValueWrapper;
import org.trimou.engine.parser.Template;
import org.trimou.engine.segment.HelperAwareSegment;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;
import org.trimou.handlebars.Helper;
import org.trimou.handlebars.HelperDefinition;
import org.trimou.handlebars.Options;
import org.trimou.util.Checker;
import org.trimou.util.Patterns;

class HelperExecutionHandler {
    private static final Splitter hashEntrySplitter = Splitter.on((String)"=").omitEmptyStrings();
    private static final Pattern literalPattern = Patterns.newHelperStringLiteralPattern();
    private final Helper helper;
    private final OptionsBuilder optionsBuilder;

    private HelperExecutionHandler(Helper helper, OptionsBuilder optionsBuilder) {
        this.helper = helper;
        this.optionsBuilder = optionsBuilder;
    }

    static HelperExecutionHandler from(String name, MustacheEngine engine, HelperAwareSegment segment) {
        Iterator<String> parts = HelperExecutionHandler.splitHelperName(name);
        Helper helper = engine.getConfiguration().getHelpers().get(parts.next());
        if (helper == null) {
            return null;
        }
        ImmutableList.Builder params = ImmutableList.builder();
        ImmutableMap.Builder hash = ImmutableMap.builder();
        while (parts.hasNext()) {
            String paramOrHash = parts.next();
            if (paramOrHash.contains("=")) {
                Iterator hashResult = hashEntrySplitter.split((CharSequence)paramOrHash).iterator();
                hash.put(hashResult.next(), HelperExecutionHandler.getLiteralOrPlaceholder((String)hashResult.next()));
                continue;
            }
            params.add(HelperExecutionHandler.getLiteralOrPlaceholder(paramOrHash));
        }
        OptionsBuilder optionsBuilder = new OptionsBuilder((List)params.build(), (Map)hash.build(), segment, engine);
        helper.validate(optionsBuilder);
        return new HelperExecutionHandler(helper, optionsBuilder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void execute(Appendable appendable, ExecutionContext executionContext) {
        DefaultOptions options = this.optionsBuilder.build(appendable, executionContext);
        try {
            this.helper.execute(options);
        }
        finally {
            options.release();
        }
    }

    private static Object getLiteralOrPlaceholder(String value) {
        Matcher matcher = literalPattern.matcher(value);
        if (matcher.matches()) {
            return matcher.group(2);
        }
        return new DefaultValuePlaceholder(value);
    }

    static Iterator<String> splitHelperName(String name) {
        boolean literal = false;
        boolean whitespace = false;
        ArrayList<String> parts = new ArrayList<String>();
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            if (name.charAt(i) == ' ') {
                if (whitespace) continue;
                if (!literal) {
                    parts.add(buffer.toString());
                    buffer = new StringBuilder();
                    whitespace = true;
                    continue;
                }
                buffer.append(name.charAt(i));
                continue;
            }
            if (name.charAt(i) == '\"') {
                literal = !literal;
            }
            whitespace = false;
            buffer.append(name.charAt(i));
        }
        if (buffer.length() > 0) {
            parts.add(buffer.toString());
        }
        return parts.iterator();
    }

    private static class DefaultValuePlaceholder
    implements HelperDefinition.ValuePlaceholder {
        private final String name;

        public DefaultValuePlaceholder(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    private static class DefaultOptions
    implements Options {
        private static final Logger logger = LoggerFactory.getLogger(DefaultOptions.class);
        private final MustacheEngine engine;
        private final List<ValueWrapper> valueWrappers;
        private int pushed = 0;
        private final ExecutionContext executionContext;
        private final HelperAwareSegment segment;
        private final List<Object> parameters;
        private final Map<String, Object> hash;
        private final Appendable appendable;

        public DefaultOptions(Appendable appendable, ExecutionContext executionContext, HelperAwareSegment segment, List<Object> parameters, Map<String, Object> hash, List<ValueWrapper> valueWrappers, MustacheEngine engine) {
            this.appendable = appendable;
            this.executionContext = executionContext;
            this.segment = segment;
            this.parameters = parameters;
            this.hash = hash;
            this.valueWrappers = valueWrappers;
            this.engine = engine;
        }

        @Override
        public void append(CharSequence sequence) {
            try {
                this.appendable.append(sequence);
            }
            catch (IOException e) {
                throw new MustacheException(MustacheProblem.RENDER_IO_ERROR, (Throwable)e);
            }
        }

        @Override
        public void fn() {
            this.segment.fn(this.appendable, this.executionContext);
        }

        @Override
        public void partial(String templateId) {
            Checker.checkArgumentNotEmpty(templateId);
            Template partialTemplate = (Template)this.engine.getMustache(templateId);
            if (partialTemplate == null) {
                throw new MustacheException(MustacheProblem.RENDER_INVALID_PARTIAL_KEY, "No partial found for the given key: %s %s", templateId, this.segment.getOrigin());
            }
            this.executionContext.push(ExecutionContext.TargetStack.TEMPLATE_INVOCATION, partialTemplate);
            partialTemplate.getRootSegment().execute(this.appendable, this.executionContext);
            this.executionContext.pop(ExecutionContext.TargetStack.TEMPLATE_INVOCATION);
        }

        @Override
        public String source(String templateId) {
            Checker.checkArgumentNotEmpty(templateId);
            String mustacheSource = this.engine.getMustacheSource(templateId);
            if (mustacheSource == null) {
                throw new MustacheException(MustacheProblem.RENDER_INVALID_PARTIAL_KEY, "No mustache template found for the given key: %s %s", templateId, this.segment.getOrigin());
            }
            return mustacheSource;
        }

        @Override
        public List<Object> getParameters() {
            return this.parameters;
        }

        @Override
        public Map<String, Object> getHash() {
            return this.hash;
        }

        @Override
        public void push(Object contextObject) {
            ++this.pushed;
            this.executionContext.push(ExecutionContext.TargetStack.CONTEXT, contextObject);
        }

        @Override
        public Object pop() {
            if (this.pushed > 0) {
                --this.pushed;
                return this.executionContext.pop(ExecutionContext.TargetStack.CONTEXT);
            }
            throw new MustacheException(MustacheProblem.RENDER_HELPER_INVALID_POP_OPERATION);
        }

        @Override
        public Object peek() {
            return this.executionContext.peek(ExecutionContext.TargetStack.CONTEXT);
        }

        @Override
        public MustacheTagInfo getTagInfo() {
            return this.segment.getTagInfo();
        }

        void release() {
            for (ValueWrapper wrapper : this.valueWrappers) {
                wrapper.release();
            }
            if (this.pushed > 0) {
                for (int i = 0; i < this.pushed; ++i) {
                    this.executionContext.pop(ExecutionContext.TargetStack.CONTEXT);
                }
                logger.warn("Cleaned up {} objects pushed on the context stack [helperName: {}, template: {}]", new Object[]{this.pushed, HelperExecutionHandler.splitHelperName(this.getTagInfo().getText()).next(), this.getTagInfo().getTemplateName()});
            }
        }
    }

    private static class OptionsBuilder
    implements HelperDefinition {
        private final List<Object> parameters;
        private final Map<String, Object> hash;
        private final HelperAwareSegment segment;
        private final MustacheEngine engine;
        private final boolean isParamValuePlaceholderFound;
        private final boolean isHashValuePlaceholderFound;

        private OptionsBuilder(List<Object> parameters, Map<String, Object> hash, HelperAwareSegment segment, MustacheEngine engine) {
            this.parameters = parameters;
            this.hash = hash;
            this.segment = segment;
            this.engine = engine;
            this.isParamValuePlaceholderFound = this.initParamValuePlaceholderFound(parameters);
            this.isHashValuePlaceholderFound = this.initHashValuePlaceholderFound(hash);
        }

        @Override
        public MustacheTagInfo getTagInfo() {
            return this.segment.getTagInfo();
        }

        @Override
        public List<Object> getParameters() {
            return this.parameters;
        }

        @Override
        public Map<String, Object> getHash() {
            return this.hash;
        }

        public DefaultOptions build(Appendable appendable, ExecutionContext executionContext) {
            Map<String, Object> finalHash;
            ValueWrapper wrapper;
            List<Object> finalParams;
            ImmutableList.Builder valueWrappers = ImmutableList.builder();
            if (this.isParamValuePlaceholderFound) {
                finalParams = new ArrayList<Object>();
                for (Object object : this.parameters) {
                    if (object instanceof HelperDefinition.ValuePlaceholder) {
                        wrapper = executionContext.getValue(((HelperDefinition.ValuePlaceholder)object).getName());
                        valueWrappers.add((Object)wrapper);
                        finalParams.add(wrapper.get());
                        continue;
                    }
                    finalParams.add(object);
                }
                finalParams = Collections.unmodifiableList(finalParams);
            } else {
                finalParams = this.parameters;
            }
            if (this.isHashValuePlaceholderFound) {
                finalHash = new HashMap<String, Object>();
                for (Map.Entry entry : this.hash.entrySet()) {
                    if (entry.getValue() instanceof HelperDefinition.ValuePlaceholder) {
                        wrapper = executionContext.getValue(((HelperDefinition.ValuePlaceholder)entry.getValue()).getName());
                        valueWrappers.add((Object)wrapper);
                        finalHash.put((String)entry.getKey(), wrapper.get());
                        continue;
                    }
                    finalHash.put((String)entry.getKey(), entry.getValue());
                }
                finalHash = Collections.unmodifiableMap(finalHash);
            } else {
                finalHash = this.hash;
            }
            return new DefaultOptions(appendable, executionContext, this.segment, finalParams, finalHash, (List<ValueWrapper>)valueWrappers.build(), this.engine);
        }

        private boolean initParamValuePlaceholderFound(List<Object> parameters) {
            if (parameters.isEmpty()) {
                return false;
            }
            for (Object param : parameters) {
                if (!(param instanceof HelperDefinition.ValuePlaceholder)) continue;
                return true;
            }
            return false;
        }

        private boolean initHashValuePlaceholderFound(Map<String, Object> hash) {
            if (hash.isEmpty()) {
                return false;
            }
            for (Map.Entry<String, Object> entry : hash.entrySet()) {
                if (!(entry.getValue() instanceof HelperDefinition.ValuePlaceholder)) continue;
                return true;
            }
            return false;
        }
    }
}

