/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.segment;

import java.util.Iterator;
import org.trimou.engine.resolver.Mapper;

public final class IterationMeta
implements Mapper {
    private static final String KEY_INDEX = "iterIndex";
    private static final String KEY_HAS_NEXT = "iterHasNext";
    private static final String KEY_FIRST = "iterIsFirst";
    private static final String KEY_LAST = "iterIsLast";
    private final String alias;
    private final Iterator<?> iterator;
    private final int length;
    private int index;

    public IterationMeta(String alias, Iterator<?> iterator) {
        this(alias, iterator, 0);
    }

    public IterationMeta(String alias, int length) {
        this(alias, null, length);
    }

    private IterationMeta(String alias, Iterator<?> iterator, int length) {
        this.alias = alias;
        this.iterator = iterator;
        this.index = 1;
        this.length = length;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean hasNext() {
        return this.iterator != null ? this.iterator.hasNext() : this.index < this.length;
    }

    public boolean isFirst() {
        return this.index == 1;
    }

    public boolean isLast() {
        return this.iterator != null ? !this.iterator.hasNext() : this.index == this.length;
    }

    public boolean isOdd() {
        return !this.isEven();
    }

    public boolean isEven() {
        return this.index % 2 == 0;
    }

    public void nextIteration() {
        ++this.index;
    }

    @Override
    public Object get(String key) {
        if (this.alias.equals(key)) {
            return this;
        }
        if (KEY_INDEX.equals(key)) {
            return this.getIndex();
        }
        if (KEY_HAS_NEXT.equals(key)) {
            return this.hasNext();
        }
        if (KEY_FIRST.equals(key)) {
            return this.isFirst();
        }
        if (KEY_LAST.equals(key)) {
            return this.isLast();
        }
        return null;
    }
}

