/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.handlebars;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.trimou.handlebars.EachHelper;
import org.trimou.handlebars.EmbedHelper;
import org.trimou.handlebars.EqualsHelper;
import org.trimou.handlebars.Helper;
import org.trimou.handlebars.IfHelper;
import org.trimou.handlebars.IncludeHelper;
import org.trimou.handlebars.IsHelper;
import org.trimou.handlebars.NullCheckHelper;
import org.trimou.handlebars.NumberIsEvenHelper;
import org.trimou.handlebars.NumberIsOddHelper;
import org.trimou.handlebars.SetHelper;
import org.trimou.handlebars.UnlessHelper;
import org.trimou.handlebars.WithHelper;

public final class HelpersBuilder {
    public static final String EACH = "each";
    public static final String IF = "if";
    public static final String UNLESS = "unless";
    public static final String WITH = "with";
    public static final String IS = "is";
    public static final String IS_EVEN = "isEven";
    public static final String IS_ODD = "isOdd";
    public static final String SET = "set";
    public static final String INCLUDE = "include";
    public static final String EMBED = "embed";
    public static final String IS_EQUAL = "isEq";
    public static final String IS_NOT_EQUAL = "isNotEq";
    public static final String IS_NULL = "isNull";
    public static final String IS_NOT_NULL = "isNotNull";
    private final ImmutableMap.Builder<String, Helper> builder = ImmutableMap.builder();

    private HelpersBuilder() {
    }

    public HelpersBuilder add(String name, Helper helper) {
        this.builder.put((Object)name, (Object)helper);
        return this;
    }

    public HelpersBuilder addEach() {
        this.builder.put((Object)EACH, (Object)new EachHelper());
        return this;
    }

    public HelpersBuilder addIf() {
        this.builder.put((Object)IF, (Object)new IfHelper());
        return this;
    }

    public HelpersBuilder addUnless() {
        this.builder.put((Object)UNLESS, (Object)new UnlessHelper());
        return this;
    }

    public HelpersBuilder addWith() {
        this.builder.put((Object)WITH, (Object)new WithHelper());
        return this;
    }

    public HelpersBuilder addIs() {
        this.builder.put((Object)IS, (Object)new IsHelper());
        return this;
    }

    public HelpersBuilder addIsEven() {
        this.builder.put((Object)IS_EVEN, (Object)new NumberIsEvenHelper());
        return this;
    }

    public HelpersBuilder addIsOdd() {
        this.builder.put((Object)IS_ODD, (Object)new NumberIsOddHelper());
        return this;
    }

    public HelpersBuilder addSet() {
        this.builder.put((Object)SET, (Object)new SetHelper());
        return this;
    }

    public HelpersBuilder addInclude() {
        this.builder.put((Object)INCLUDE, (Object)new IncludeHelper());
        return this;
    }

    public HelpersBuilder addEmbed() {
        this.builder.put((Object)EMBED, (Object)new EmbedHelper());
        return this;
    }

    public HelpersBuilder addIsEqual() {
        this.builder.put((Object)IS_EQUAL, (Object)new EqualsHelper());
        return this;
    }

    public HelpersBuilder addIsNotEqual() {
        this.builder.put((Object)IS_NOT_EQUAL, (Object)new EqualsHelper(true));
        return this;
    }

    public HelpersBuilder addIsNull() {
        this.builder.put((Object)IS_NULL, (Object)new NullCheckHelper());
        return this;
    }

    public HelpersBuilder addIsNotNull() {
        this.builder.put((Object)IS_NOT_NULL, (Object)new NullCheckHelper(true));
        return this;
    }

    public HelpersBuilder addBuiltin() {
        this.addEach();
        this.addIf();
        this.addUnless();
        this.addWith();
        this.addIs();
        return this;
    }

    public HelpersBuilder addExtra() {
        this.addIsEven();
        this.addIsOdd();
        this.addSet();
        this.addInclude();
        this.addEmbed();
        this.addIsEqual();
        this.addIsNotEqual();
        this.addIsNull();
        this.addIsNotNull();
        return this;
    }

    public Map<String, Helper> build() {
        return this.builder.build();
    }

    public static HelpersBuilder empty() {
        return new HelpersBuilder();
    }

    public static HelpersBuilder builtin() {
        return HelpersBuilder.empty().addBuiltin();
    }

    public static HelpersBuilder extra() {
        return HelpersBuilder.empty().addExtra();
    }

    public static HelpersBuilder all() {
        return HelpersBuilder.builtin().addExtra();
    }
}

