/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.handlebars;

import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trimou.handlebars.BasicSectionHelper;
import org.trimou.handlebars.Options;

abstract class MatchingSectionHelper
extends BasicSectionHelper {
    private static final Logger logger = LoggerFactory.getLogger(MatchingSectionHelper.class);
    private static final String OPTION_KEY_LOGIC = "logic";

    MatchingSectionHelper() {
    }

    @Override
    public void execute(Options options) {
        if (options.getParameters().isEmpty() && this.isMatching(options.peek()) || this.matches(this.getLogic(options.getHash()), options.getParameters())) {
            options.fn();
        }
    }

    protected EvaluationLogic getDefaultLogic() {
        return EvaluationLogic.AND;
    }

    protected abstract boolean isMatching(Object var1);

    protected boolean hasEmptyParamsSupport() {
        return false;
    }

    @Override
    protected int numberOfRequiredParameters() {
        return this.hasEmptyParamsSupport() ? 0 : super.numberOfRequiredParameters();
    }

    private boolean matches(EvaluationLogic logic, List<Object> params) {
        switch (logic) {
            case AND: {
                for (Object param : params) {
                    if (this.isMatching(param)) continue;
                    return false;
                }
                return true;
            }
            case OR: {
                for (Object param : params) {
                    if (!this.isMatching(param)) continue;
                    return true;
                }
                return false;
            }
        }
        throw new IllegalStateException();
    }

    private EvaluationLogic getLogic(Map<String, Object> hash) {
        if (hash.isEmpty() || !hash.containsKey(OPTION_KEY_LOGIC)) {
            return this.getDefaultLogic();
        }
        String customLogic = hash.get(OPTION_KEY_LOGIC).toString();
        EvaluationLogic logic = EvaluationLogic.parse(customLogic);
        if (logic == null) {
            logger.warn("Unsupported evaluation logic specified: {}, using the default one: {}", (Object)customLogic, (Object)this.getDefaultLogic());
            logic = this.getDefaultLogic();
        }
        return logic;
    }

    protected static enum EvaluationLogic {
        OR,
        AND;


        public static EvaluationLogic parse(String value) {
            for (EvaluationLogic logic : EvaluationLogic.values()) {
                if (!value.equalsIgnoreCase(logic.toString())) continue;
                return logic;
            }
            return null;
        }
    }
}

