/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.util;

import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.trimou.annotations.Internal;
import org.trimou.util.Checker;
import org.trimou.util.StringBuilderWriter;

@Internal
public final class IOUtils {
    private IOUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(Reader input) throws IOException {
        Checker.checkArgumentNotNull(input);
        try {
            String string = CharStreams.toString((Readable)input);
            return string;
        }
        finally {
            input.close();
        }
    }

    public static String toString(Reader input, int bufferSize) throws IOException {
        StringBuilderWriter writer = new StringBuilderWriter();
        IOUtils.copy(input, writer, bufferSize);
        return writer.toString();
    }

    public static void copy(Reader input, Writer output, int bufferSize) throws IOException {
        char[] buffer = new char[bufferSize];
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
        output.flush();
    }
}

