/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.util;

import java.util.regex.Pattern;
import org.trimou.engine.config.Configuration;
import org.trimou.engine.config.EngineConfigurationKey;

public final class Patterns {
    private Patterns() {
    }

    public static Pattern newMustacheTagPattern(Configuration configuration) {
        StringBuilder regex = new StringBuilder();
        regex.append(Pattern.quote(configuration.getStringPropertyValue(EngineConfigurationKey.START_DELIMITER)));
        regex.append(".*?");
        regex.append(Pattern.quote(configuration.getStringPropertyValue(EngineConfigurationKey.END_DELIMITER)));
        return Pattern.compile(regex.toString());
    }

    public static Pattern newSetDelimitersContentPattern() {
        return Pattern.compile("(\\S+)(\\s+)(\\S+)");
    }

    public static Pattern newHelperNameValidationPattern() {
        return Pattern.compile("([\\p{L}\\p{Nd}\\p{P}\\p{S}=]+[ ]*)+?");
    }

    public static Pattern newHelperStringLiteralPattern() {
        return Pattern.compile("(\")(.*)(\")");
    }
}

