/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.interpolation;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.trimou.engine.interpolation.DotKeySplitter;

public class BracketDotKeySplitter
extends DotKeySplitter {
    private static final String PREFIX = "_";
    private final Pattern pattern = Pattern.compile("(\\[\")(.*?)(\"\\])");

    @Override
    public Iterator<String> split(String key) {
        Map<Object, Object> literalMap;
        int matches = StringUtils.countMatches((CharSequence)key, (CharSequence)"[\"");
        if (matches == 0) {
            return super.split(key);
        }
        Matcher matcher = this.pattern.matcher(key);
        StringBuffer buffer = new StringBuffer();
        int idx = 0;
        if (matches == 1) {
            if (matcher.find()) {
                literalMap = Collections.singletonMap(PREFIX + idx, matcher.group(2));
                matcher.appendReplacement(buffer, "._" + idx);
            } else {
                literalMap = Collections.emptyMap();
            }
        } else {
            literalMap = new HashMap(4);
            while (matcher.find()) {
                String id = PREFIX + idx;
                literalMap.put(id, matcher.group(2));
                matcher.appendReplacement(buffer, "." + id);
                ++idx;
            }
        }
        matcher.appendTail(buffer);
        return Iterators.transform(super.split(buffer.toString()), (Function)new Function<String, String>(){

            public String apply(String input) {
                return literalMap.containsKey(input) ? (String)literalMap.get(input) : input;
            }
        });
    }
}

