/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.segment;

import java.util.Iterator;
import java.util.List;
import org.trimou.engine.context.ExecutionContext;
import org.trimou.engine.segment.AbstractSegment;
import org.trimou.engine.segment.ContainerSegment;
import org.trimou.engine.segment.Origin;
import org.trimou.engine.segment.Segment;

abstract class AbstractContainerSegment
extends AbstractSegment
implements ContainerSegment {
    private final List<Segment> segments;

    public AbstractContainerSegment(String name, Origin origin, List<Segment> segments) {
        super(name, origin);
        this.segments = segments;
    }

    @Override
    public void execute(Appendable appendable, ExecutionContext context) {
        for (Segment segment : this.segments) {
            segment.execute(appendable, context);
        }
    }

    @Override
    public Iterator<Segment> iterator() {
        return this.getSegments().iterator();
    }

    @Override
    public List<Segment> getSegments() {
        return this.segments;
    }

    @Override
    public int getSegmentsSize(boolean recursive) {
        if (recursive) {
            int count = 0;
            for (Segment segment : this) {
                ++count;
                if (!(segment instanceof ContainerSegment)) continue;
                count += ((ContainerSegment)segment).getSegmentsSize(true);
            }
            return count;
        }
        return this.segments.size();
    }

    protected String getContainingLiteralBlock() {
        StringBuilder literal = new StringBuilder();
        for (Segment segment : this.segments) {
            literal.append(segment.getLiteralBlock());
        }
        return literal.toString();
    }

    @Override
    protected String getSegmentName() {
        return this.getText();
    }
}

