/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.handlebars;

import com.google.common.base.Preconditions;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trimou.engine.MustacheTagType;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;
import org.trimou.handlebars.HelperDefinition;
import org.trimou.util.Checker;

public final class HelperValidator {
    private static final Logger logger = LoggerFactory.getLogger(HelperValidator.class);

    private HelperValidator() {
    }

    public static void checkParams(Class<?> helperClazz, HelperDefinition definition, int paramSize) {
        Checker.checkArgumentNotNull(definition);
        Preconditions.checkArgument((paramSize >= 0 ? 1 : 0) != 0, (Object)"Helper may only require zero or more params");
        int size = definition.getParameters().size();
        if (size < paramSize) {
            throw new MustacheException(MustacheProblem.COMPILE_HELPER_VALIDATION_FAILURE, "Insufficient number of parameters for helper %s [expected: %s, current: %s, template: %s, line: %s]", helperClazz.getName(), paramSize, size, definition.getTagInfo().getTemplateName(), definition.getTagInfo().getLine());
        }
        if (size > paramSize) {
            logger.trace("{} superfluous parameters detected [helper: {}, template: {}, line: {}]", new Object[]{size - paramSize, helperClazz.getName(), definition.getTagInfo().getTemplateName(), definition.getTagInfo().getLine()});
        }
    }

    public static void checkType(Class<?> helperClazz, HelperDefinition definition, MustacheTagType ... allowedTypes) {
        Checker.checkArgumentsNotNull(new Object[]{definition, allowedTypes});
        if (!ArrayUtils.contains((Object[])allowedTypes, (Object)((Object)definition.getTagInfo().getType()))) {
            throw new MustacheException(MustacheProblem.COMPILE_HELPER_VALIDATION_FAILURE, "Unsupported tag type [helper: %s, template: %s, line: %s]", helperClazz.getName(), definition.getTagInfo().getTemplateName(), definition.getTagInfo().getLine());
        }
    }

    public static void checkHash(Class<?> helperClazz, HelperDefinition definition, int hashSize) {
        Checker.checkArgumentNotNull(definition);
        Preconditions.checkArgument((hashSize >= 0 ? 1 : 0) != 0, (Object)"Helper may only require zero or more hash entries");
        int size = definition.getHash().size();
        if (size < hashSize) {
            throw new MustacheException(MustacheProblem.COMPILE_HELPER_VALIDATION_FAILURE, "Insufficient number of hash entries for helper %s [expected: %s, current: %s, template: %s, line: %s]", helperClazz.getName(), hashSize, size, definition.getTagInfo().getTemplateName(), definition.getTagInfo().getLine());
        }
        if (size > hashSize) {
            logger.trace("{} superfluous hash entries detected [helper: {}, template: {}, line: {}]", new Object[]{size - hashSize, helperClazz.getName(), definition.getTagInfo().getTemplateName(), definition.getTagInfo().getLine()});
        }
    }
}

