/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.handlebars;

import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trimou.handlebars.BasicValueHelper;
import org.trimou.handlebars.Options;
import org.trimou.util.Arrays;
import org.trimou.util.Checker;

public class LogHelper
extends BasicValueHelper {
    private static final Logger logger = LoggerFactory.getLogger(LogHelper.class);
    private static final String OPTION_KEY_LEVEL = "level";
    private final LoggerAdapter adapter;
    private final Level defaultLevel;
    private final boolean appendTemplateInfo;

    public LogHelper(LoggerAdapter adapter, Level defaultLevel, boolean appendTemplateInfo) {
        Checker.checkArgumentsNotNull(new Object[]{adapter, defaultLevel});
        this.defaultLevel = defaultLevel;
        this.adapter = adapter;
        this.appendTemplateInfo = appendTemplateInfo;
    }

    @Override
    public void execute(Options options) {
        String message = options.getParameters().get(0).toString();
        if (this.appendTemplateInfo) {
            StringBuilder builder = new StringBuilder(message);
            builder.append(" [");
            builder.append(options.getTagInfo().getTemplateName());
            builder.append(":");
            builder.append(options.getTagInfo().getLine());
            builder.append("]");
            message = builder.toString();
        }
        this.adapter.log(this.getLevel(options.getHash()), message, this.getMessageParams(options.getParameters()));
    }

    private Level getLevel(Map<String, Object> hash) {
        if (hash.isEmpty() || !hash.containsKey(OPTION_KEY_LEVEL)) {
            return this.defaultLevel;
        }
        String customLevel = hash.get(OPTION_KEY_LEVEL).toString();
        Level level = Level.parse(customLevel);
        if (level == null) {
            logger.warn("Unsupported level specified: {}, using the default one: {}", (Object)customLevel, (Object)this.defaultLevel);
            level = this.defaultLevel;
        }
        return level;
    }

    private Object[] getMessageParams(List<Object> params) {
        if (params.size() > 1) {
            return params.subList(1, params.size()).toArray();
        }
        return Arrays.EMPTY_OBJECT_ARRAY;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Slf4jLoggerAdapter
    implements LoggerAdapter {
        private final Logger logger;

        public Slf4jLoggerAdapter(String name) {
            this.logger = LoggerFactory.getLogger((String)name);
        }

        @Override
        public void log(Level level, String message, Object[] params) {
            switch (level) {
                case ERROR: {
                    this.logger.error(message, params);
                    break;
                }
                case WARN: {
                    this.logger.warn(message, params);
                    break;
                }
                case INFO: {
                    this.logger.info(message, params);
                    break;
                }
                case DEBUG: {
                    this.logger.debug(message, params);
                    break;
                }
                case TRACE: {
                    this.logger.trace(message, params);
                    break;
                }
            }
        }
    }

    public static interface LoggerAdapter {
        public void log(Level var1, String var2, Object[] var3);
    }

    public static enum Level {
        ERROR,
        WARN,
        INFO,
        DEBUG,
        TRACE;


        static Level parse(String value) {
            for (Level level : Level.values()) {
                if (!value.equals(level.toString())) continue;
                return level;
            }
            return null;
        }
    }

    public static class Builder {
        private Level level;
        private LoggerAdapter adapter;
        private boolean appendTemplateInfo = true;

        public Builder setDefaultLevel(Level level) {
            this.level = level;
            return this;
        }

        public Builder setLoggerAdapter(LoggerAdapter adapter) {
            this.adapter = adapter;
            return this;
        }

        public Builder setAppendTemplateInfo(boolean value) {
            this.appendTemplateInfo = value;
            return this;
        }

        public LogHelper build() {
            return new LogHelper(this.adapter != null ? this.adapter : new Slf4jLoggerAdapter(LogHelper.class.getName()), this.level != null ? this.level : Level.INFO, this.appendTemplateInfo);
        }
    }
}

