/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.handlebars;

import java.util.Map;
import org.trimou.handlebars.BasicSectionHelper;
import org.trimou.handlebars.Flow;
import org.trimou.handlebars.Options;

public class SwitchHelper
extends BasicSectionHelper {
    @Override
    protected int numberOfRequiredParameters() {
        return 0;
    }

    @Override
    public void execute(Options options) {
        Object value;
        Object object = value = options.getParameters().isEmpty() ? options.peek() : options.getParameters().get(0);
        if (value == null) {
            return;
        }
        options.push(new Flow(value));
        options.fn();
        options.pop();
    }

    public static class DefaultHelper
    extends BasicSectionHelper {
        @Override
        protected int numberOfRequiredParameters() {
            return 0;
        }

        @Override
        public void execute(Options options) {
            Object contextObject = options.peek();
            if (contextObject instanceof Flow) {
                Flow flow = (Flow)contextObject;
                if (!flow.isTerminated()) {
                    options.fn();
                    flow.terminate();
                }
            } else {
                throw Flow.newInvalidFlowException(options.getTagInfo());
            }
        }
    }

    public static class CaseHelper
    extends BasicSectionHelper {
        private static final String OPTION_BREAK = "break";
        private final boolean defaultIsBreak;

        public CaseHelper() {
            this(false);
        }

        public CaseHelper(boolean defaultIsBreak) {
            this.defaultIsBreak = defaultIsBreak;
        }

        @Override
        public void execute(Options options) {
            Object contextObject = options.peek();
            if (contextObject instanceof Flow) {
                Flow flow = (Flow)contextObject;
                if (!flow.isTerminated() && (flow.isFallThrough() || flow.up().equals(options.getParameters().get(0)))) {
                    options.fn();
                    flow.setFallThrough();
                    if (this.isBreak(options.getHash())) {
                        flow.terminate();
                    }
                }
            } else {
                throw Flow.newInvalidFlowException(options.getTagInfo());
            }
        }

        private boolean isBreak(Map<String, Object> hash) {
            if (hash.isEmpty() || !hash.containsKey(OPTION_BREAK)) {
                return this.defaultIsBreak;
            }
            return Boolean.valueOf(hash.get(OPTION_BREAK).toString());
        }
    }
}

