/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.cache;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.trimou.AbstractTest;
import org.trimou.Hammer;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.engine.cache.ComputingCache;
import org.trimou.engine.cache.ComputingCacheFactory;
import org.trimou.engine.config.AbstractConfigurationAware;
import org.trimou.engine.locator.MapTemplateLocator;
import org.trimou.engine.locator.TemplateLocator;
import org.trimou.engine.resolver.ReflectionResolver;
import org.trimou.engine.resolver.Resolver;

public class CustomComputingCacheFactoryTest
extends AbstractTest {
    @Test
    public void testCustomFactory() {
        CustomFactory factory = new CustomFactory();
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().addTemplateLocator((TemplateLocator)new MapTemplateLocator((Map)ImmutableMap.of((Object)"foo", (Object)"{{this.age}}"))).setComputingCacheFactory((ComputingCacheFactory)factory).build();
        Assert.assertEquals((Object)"10", (Object)engine.getMustache("foo").render((Object)new Hammer()));
        List reflectionCaches = factory.caches.get((Object)ReflectionResolver.COMPUTING_CACHE_CONSUMER_ID);
        Assert.assertEquals((long)1L, (long)reflectionCaches.size());
        CustomComputingCache reflectionCache = (CustomComputingCache)reflectionCaches.get(0);
        Assert.assertEquals((long)1L, (long)reflectionCache.size());
        List templateCaches = factory.caches.get((Object)MustacheEngine.COMPUTING_CACHE_CONSUMER_ID);
        Assert.assertEquals((long)2L, (long)templateCaches.size());
        for (CustomComputingCache cache : templateCaches) {
            cache.clear();
        }
        this.getReflectionResolver(engine).invalidateMemberCache(null);
        Assert.assertEquals((long)0L, (long)reflectionCache.size());
        Assert.assertEquals((Object)"10", (Object)engine.getMustache("foo").render((Object)new Hammer()));
    }

    private ReflectionResolver getReflectionResolver(MustacheEngine engine) {
        for (Resolver resolver : engine.getConfiguration().getResolvers()) {
            if (!(resolver instanceof ReflectionResolver)) continue;
            return (ReflectionResolver)resolver;
        }
        return null;
    }

    private static class CustomComputingCache<K, V>
    implements ComputingCache<K, V> {
        final Map<K, V> map;
        final ComputingCache.Function<K, V> computingFunction;

        public CustomComputingCache(Map<K, V> map, ComputingCache.Function<K, V> computingFunction) {
            this.map = map;
            this.computingFunction = computingFunction;
        }

        public synchronized V get(K key) {
            Object value = this.map.get(key);
            if (value == null) {
                value = this.computingFunction.compute(key);
                this.map.put(key, value);
            }
            return value;
        }

        public synchronized void clear() {
            this.map.clear();
        }

        public synchronized long size() {
            return this.map.size();
        }

        public synchronized void invalidate(ComputingCache.KeyPredicate<K> keyPredicate) {
            Iterator<Map.Entry<K, V>> iterator = this.map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<K, V> entry = iterator.next();
                if (!keyPredicate.apply(entry.getKey())) continue;
                iterator.remove();
            }
        }

        public synchronized V getIfPresent(K key) {
            return this.map.get(key);
        }

        public synchronized Map<K, V> getAllPresent() {
            return ImmutableMap.copyOf(this.map);
        }
    }

    private static class CustomFactory
    extends AbstractConfigurationAware
    implements ComputingCacheFactory {
        final ListMultimap<String, CustomComputingCache> caches = ArrayListMultimap.create();

        private CustomFactory() {
        }

        public <K, V> ComputingCache<K, V> create(String consumerId, ComputingCache.Function<K, V> computingFunction, Long expirationTimeout, Long maxSize, ComputingCache.Listener<K> listener) {
            CustomComputingCache cache = new CustomComputingCache(new HashMap(), computingFunction);
            this.caches.put((Object)consumerId, cache);
            return cache;
        }
    }
}

