/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.interpolation;

import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;
import org.trimou.engine.interpolation.BracketDotKeySplitter;

public class BracketDotKeySplitterTest {
    @Test
    public void testSplit() {
        BracketDotKeySplitter splitter = new BracketDotKeySplitter();
        this.assertIterator(splitter.split("a..bar:.c"), "a", "bar:", "c");
        this.assertIterator(splitter.split(". "), " ");
        this.assertIterator(splitter.split("."), ".");
        this.assertIterator(splitter.split("foo"), "foo");
        this.assertIterator(splitter.split("foo[\"bar\"]"), "foo", "bar");
        this.assertIterator(splitter.split("foo[\"a.b.c\"]"), "foo", "a.b.c");
        this.assertIterator(splitter.split("foo[\"bar\"].baz"), "foo", "bar", "baz");
        this.assertIterator(splitter.split("a[\"b\"].c.d[\"e\"][\"f\"]"), "a", "b", "c", "d", "e", "f");
    }

    private void assertIterator(Iterator<String> iterator, Object ... elements) {
        int idx = 0;
        while (iterator.hasNext()) {
            Assert.assertEquals((Object)elements[idx], (Object)iterator.next());
            ++idx;
        }
        if (idx != elements.length) {
            Assert.fail((String)"Incorrect number of elements");
        }
    }
}

